/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time.chrono;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.time.InstantAssert;
import io.github.imsejin.common.assertion.time.LocalTimeAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoLocalDateAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import io.github.imsejin.common.util.DateTimeUtils;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;

public class ChronoLocalDateTimeAssert<SELF extends ChronoLocalDateTimeAssert<SELF, DATE>, DATE extends ChronoLocalDate>
extends AbstractTemporalAccessorAssert<SELF, ChronoLocalDateTime<?>> {
    public ChronoLocalDateTimeAssert(ChronoLocalDateTime<DATE> actual) {
        super(actual);
    }

    protected ChronoLocalDateTimeAssert(Descriptor<?> descriptor, ChronoLocalDateTime<?> actual) {
        super(descriptor, actual);
    }

    public ChronoLocalDateAssert<?> asLocalDate() {
        Object localDate = ((ChronoLocalDateTime)this.actual).toLocalDate();
        return new ChronoLocalDateAssert((Descriptor<?>)this, (ChronoLocalDate)localDate);
    }

    public LocalTimeAssert<?> asLocalTime() {
        LocalTime localTime = ((ChronoLocalDateTime)this.actual).toLocalTime();
        class LocalTimeAssertImpl
        extends LocalTimeAssert<LocalTimeAssertImpl> {
            LocalTimeAssertImpl(Descriptor<?> descriptor, LocalTime actual) {
                super(descriptor, actual);
            }
        }
        return new LocalTimeAssertImpl(this, localTime);
    }

    public InstantAssert<?> asInstant() {
        ZoneOffset zoneOffset = DateTimeUtils.getSystemDefaultZoneOffset();
        Instant instant = ((ChronoLocalDateTime)this.actual).toInstant(zoneOffset);
        class InstantAssertImpl
        extends InstantAssert<InstantAssertImpl> {
            InstantAssertImpl(Descriptor<?> descriptor, Instant actual) {
                super(descriptor, actual);
            }
        }
        return new InstantAssertImpl(this, instant);
    }
}

