/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time.chrono;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.time.InstantAssert;
import io.github.imsejin.common.assertion.time.LocalTimeAssert;
import io.github.imsejin.common.assertion.time.OffsetDateTimeAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoLocalDateAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoLocalDateTimeAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;

public class ChronoZonedDateTimeAssert<SELF extends ChronoZonedDateTimeAssert<SELF, DATE>, DATE extends ChronoLocalDate>
extends AbstractTemporalAccessorAssert<SELF, ChronoZonedDateTime<?>> {
    public ChronoZonedDateTimeAssert(ChronoZonedDateTime<DATE> actual) {
        super(actual);
    }

    protected ChronoZonedDateTimeAssert(Descriptor<?> descriptor, ChronoZonedDateTime<?> actual) {
        super(descriptor, actual);
    }

    public SELF isSameZone(ZoneId expected) {
        ZoneId zone = ((ChronoZonedDateTime)this.actual).getZone();
        if (!zone.equals(expected)) {
            this.setDefaultDescription("They are expected to have the same zone, but they aren't. (expected: '{0}', actual: '{1}')", expected, zone);
            throw this.getException();
        }
        return (SELF)((ChronoZonedDateTimeAssert)this.self);
    }

    public SELF isNotSameZone(ZoneId expected) {
        ZoneId zone = ((ChronoZonedDateTime)this.actual).getZone();
        if (zone.equals(expected)) {
            this.setDefaultDescription("They are expected not to have the same zone, but they are. (expected: '{0}', actual: '{1}')", expected, zone);
            throw this.getException();
        }
        return (SELF)((ChronoZonedDateTimeAssert)this.self);
    }

    public ChronoLocalDateAssert<?> asLocalDate() {
        Object localDate = ((ChronoZonedDateTime)this.actual).toLocalDate();
        return new ChronoLocalDateAssert((Descriptor<?>)this, (ChronoLocalDate)localDate);
    }

    public ChronoLocalDateTimeAssert<?, DATE> asLocalDateTime() {
        ChronoLocalDateTime localDateTime = ((ChronoZonedDateTime)this.actual).toLocalDateTime();
        return new ChronoLocalDateTimeAssert((Descriptor<?>)this, localDateTime);
    }

    public LocalTimeAssert<?> asLocalTime() {
        LocalTime localTime = ((ChronoZonedDateTime)this.actual).toLocalTime();
        class LocalTimeAssertImpl
        extends LocalTimeAssert<LocalTimeAssertImpl> {
            LocalTimeAssertImpl(Descriptor<?> descriptor, LocalTime actual) {
                super(descriptor, actual);
            }
        }
        return new LocalTimeAssertImpl(this, localTime);
    }

    public OffsetDateTimeAssert<?> asOffsetDateTime() {
        LocalDateTime dateTime = LocalDateTime.ofInstant(((ChronoZonedDateTime)this.actual).toInstant(), ((ChronoZonedDateTime)this.actual).getZone());
        ZoneOffset offset = ((ChronoZonedDateTime)this.actual).getOffset();
        OffsetDateTime offsetDateTime = OffsetDateTime.of(dateTime, offset);
        class OffsetDateTimeAssertImpl
        extends OffsetDateTimeAssert<OffsetDateTimeAssertImpl> {
            OffsetDateTimeAssertImpl(Descriptor<?> descriptor, OffsetDateTime actual) {
                super(descriptor, actual);
            }
        }
        return new OffsetDateTimeAssertImpl(this, offsetDateTime);
    }

    public InstantAssert<?> asInstant() {
        Instant instant = ((ChronoZonedDateTime)this.actual).toInstant();
        class InstantAssertImpl
        extends InstantAssert<InstantAssertImpl> {
            InstantAssertImpl(Descriptor<?> descriptor, Instant actual) {
                super(descriptor, actual);
            }
        }
        return new InstantAssertImpl(this, instant);
    }
}

