/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.EnumerationAssertable;
import io.github.imsejin.common.assertion.composition.IterationAssertable;
import io.github.imsejin.common.assertion.lang.ArrayAssert;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.util.ArrayUtils;
import io.github.imsejin.common.util.CollectionUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;

public class CollectionAssert<SELF extends CollectionAssert<SELF, ACTUAL, ELEMENT>, ACTUAL extends Collection<? extends ELEMENT>, ELEMENT>
extends ObjectAssert<SELF, ACTUAL>
implements EnumerationAssertable<SELF, ELEMENT>,
IterationAssertable<SELF, ACTUAL, ELEMENT> {
    public CollectionAssert(ACTUAL actual) {
        super(actual);
    }

    protected CollectionAssert(Descriptor<?> descriptor, ACTUAL actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isEmpty() {
        if (!((Collection)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to be empty, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Collection)this.actual).size()));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF isNotEmpty() {
        if (((Collection)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected not to be empty, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Collection)this.actual).size()));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF hasSize(long expected) {
        int size = ((Collection)this.actual).size();
        if ((long)size != expected) {
            this.setDefaultDescription("It is expected to have the given size, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSize(long expected) {
        int size = ((Collection)this.actual).size();
        if ((long)size == expected) {
            this.setDefaultDescription("It is expected not to have the given size, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", size), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF hasSameSizeAs(Collection expected) {
        Integer expectedSize;
        Integer n = expectedSize = expected == null ? null : Integer.valueOf(expected.size());
        if (expected == null || ((Collection)this.actual).size() != expectedSize.intValue()) {
            this.setDefaultDescription("They are expected to have the same size, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Collection)this.actual).size()), new AbstractMap.SimpleEntry<String, Collection>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF doesNotHaveSameSizeAs(Collection expected) {
        Integer expectedSize;
        Integer n = expectedSize = expected == null ? null : Integer.valueOf(expected.size());
        if (expected == null || ((Collection)this.actual).size() == expectedSize.intValue()) {
            this.setDefaultDescription("They are expected not to have the same size, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Collection)this.actual).size()), new AbstractMap.SimpleEntry<String, Collection>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expectedSize));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThan(long expected) {
        if ((long)((Collection)this.actual).size() <= expected) {
            this.setDefaultDescription("It is expected to have size greater than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Collection)this.actual).size()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(long expected) {
        if ((long)((Collection)this.actual).size() < expected) {
            this.setDefaultDescription("It is expected to have size greater than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Collection)this.actual).size()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThan(long expected) {
        if ((long)((Collection)this.actual).size() >= expected) {
            this.setDefaultDescription("It is expected to have size less than the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Collection)this.actual).size()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(long expected) {
        if ((long)((Collection)this.actual).size() > expected) {
            this.setDefaultDescription("It is expected to have size less than or same as the given one, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((Collection)this.actual).size()), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF contains(ELEMENT expected) {
        for (Object element : (Collection)this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            return (SELF)((CollectionAssert)this.self);
        }
        this.setDefaultDescription("It is expected to contain the given element, but it isn't.", new Object[0]);
        this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT>("expected", expected));
        throw this.getException();
    }

    @Override
    public SELF doesNotContain(ELEMENT expected) {
        for (Object element : (Collection)this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            this.setDefaultDescription("It is expected not to contain the given element, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT>("expected", expected));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF containsNull() {
        for (Object element : (Collection)this.actual) {
            if (element != null) continue;
            return (SELF)((CollectionAssert)this.self);
        }
        this.setDefaultDescription("It is expected to contain null, but it isn't.", new Object[0]);
        this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
        throw this.getException();
    }

    @Override
    public SELF doesNotContainNull() {
        for (Object element : (Collection)this.actual) {
            if (element != null) continue;
            this.setDefaultDescription("It is expected not to contain null, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF containsAny(ELEMENT ... expected) {
        if (((Collection)this.actual).size() == 0 && expected.length == 0) {
            return (SELF)((CollectionAssert)this.self);
        }
        for (ELEMENT item : expected) {
            for (Object element : (Collection)this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                return (SELF)((CollectionAssert)this.self);
            }
        }
        this.setDefaultDescription("It is expected to contain at least one of the given element(s), but it isn't.", new Object[0]);
        this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected));
        throw this.getException();
    }

    @Override
    public SELF containsAll(ACTUAL expected) {
        if (CollectionUtils.isNullOrEmpty(expected)) {
            return (SELF)((CollectionAssert)this.self);
        }
        block0: for (Object item : expected) {
            for (Object element : (Collection)this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                continue block0;
            }
            this.setDefaultDescription("It is expected to contain all the given elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected), new AbstractMap.SimpleEntry("missing", item));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF doesNotContainAll(ACTUAL expected) {
        if (((Collection)this.actual).isEmpty() || CollectionUtils.isNullOrEmpty(expected)) {
            return (SELF)((CollectionAssert)this.self);
        }
        for (Object item : expected) {
            for (Object element : (Collection)this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                this.setDefaultDescription("It is expected not to contain all the given elements, but it is.", new Object[0]);
                this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected), new AbstractMap.SimpleEntry("included", element));
                throw this.getException();
            }
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF containsOnly(ELEMENT ... expected) {
        if (((Collection)this.actual).size() == 0 && expected.length == 0) {
            return (SELF)((CollectionAssert)this.self);
        }
        block0: for (ELEMENT item : expected) {
            for (Object element : (Collection)this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                continue block0;
            }
            this.setDefaultDescription("It is expected to contain only the given element(s), but it doesn't contain some element(s).", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, ELEMENT>("missing", item));
            throw this.getException();
        }
        block2: for (Object element : (Collection)this.actual) {
            for (ELEMENT item : expected) {
                if (Objects.deepEquals(element, item)) continue block2;
            }
            this.setDefaultDescription("It is expected to contain only the given element(s), but it contains unexpected element(s).", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry("unexpected", element));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF containsOnlyNulls() {
        if (((Collection)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to contain only null elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        for (Object element : (Collection)this.actual) {
            if (element == null) continue;
            this.setDefaultDescription("It is expected to contain only null elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF containsOnlyOnce(ELEMENT expected) {
        ArrayList elements = new ArrayList();
        for (Object element : (Collection)this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            elements.add(element);
        }
        if (elements.size() != 1) {
            this.setDefaultDescription("It is expected to contain the given element only once, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT>("expected", expected), new AbstractMap.SimpleEntry("matched", elements));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF containsWithFrequency(int frequency, ELEMENT expected) {
        if (frequency < 0) {
            this.setDefaultDescription("It is expected to contain the given element with frequency, but the frequency is negative.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("frequency", frequency));
            throw this.getException();
        }
        ArrayList elements = new ArrayList();
        for (Object element : (Collection)this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            elements.add(element);
        }
        if (elements.size() != frequency) {
            this.setDefaultDescription("It is expected to contain the given element with frequency, but actual frequency is different from the frequency.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT>("expected", expected), new AbstractMap.SimpleEntry("matched", elements), new AbstractMap.SimpleEntry<String, Integer>("actual-frequency", elements.size()), new AbstractMap.SimpleEntry<String, Integer>("expected-frequency", frequency));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF doesNotHaveDuplicates() {
        if (((Collection)this.actual).isEmpty() || ((Collection)this.actual).size() == 1) {
            return (SELF)((CollectionAssert)this.self);
        }
        TreeSet noDuplicates = new TreeSet((o1, o2) -> {
            if (Objects.deepEquals(o1, o2)) {
                return 0;
            }
            return ArrayUtils.hashCode(o1) < ArrayUtils.hashCode(o2) ? -1 : 1;
        });
        for (Object element : (Collection)this.actual) {
            if (noDuplicates.contains(element)) {
                this.setDefaultDescription("It is expected not to have duplicated elements, but it is.", new Object[0]);
                this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry("duplicated", element));
                throw this.getException();
            }
            noDuplicates.add(element);
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF anyMatch(Predicate<ELEMENT> expected) {
        for (Object element : (Collection)this.actual) {
            if (!expected.test(element)) continue;
            return (SELF)((CollectionAssert)this.self);
        }
        this.setDefaultDescription("It is expected to match the given condition with its any elements, but it isn't.", new Object[0]);
        this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
        throw this.getException();
    }

    @Override
    public SELF allMatch(Predicate<ELEMENT> expected) {
        if (((Collection)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to match the given condition with its all elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        for (Object element : (Collection)this.actual) {
            if (expected.test(element)) continue;
            this.setDefaultDescription("It is expected to match the given condition with its all elements, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry("unmatched", element));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF noneMatch(Predicate<ELEMENT> expected) {
        for (Object element : (Collection)this.actual) {
            if (!expected.test(element)) continue;
            this.setDefaultDescription("It is expected not to match the given condition with its all elements, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry("matched", element));
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    public ArrayAssert<?, ELEMENT> asArray() {
        Object[] elements = ((Collection)this.actual).toArray(new Object[0]);
        class ArrayAssertImpl
        extends ArrayAssert<ArrayAssertImpl, ELEMENT> {
            ArrayAssertImpl(Descriptor<?> descriptor, ELEMENT[] actual) {
                super(descriptor, actual);
            }
        }
        return new ArrayAssertImpl(this, elements);
    }

    public IntegerAssert<?> asSize() {
        int size = ((Collection)this.actual).size();
        class IntegerAssertImpl
        extends IntegerAssert<IntegerAssertImpl> {
            IntegerAssertImpl(Descriptor<?> descriptor, Integer actual) {
                super(descriptor, actual);
            }
        }
        return new IntegerAssertImpl(this, size);
    }
}

