/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.PositionComparisonAssertable;
import io.github.imsejin.common.assertion.composition.YearAssertable;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.time.InstantAssert;
import io.github.imsejin.common.assertion.time.YearMonthAssert;
import java.time.Instant;
import java.time.Year;
import java.time.YearMonth;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Date;

public class DateAssert<SELF extends DateAssert<SELF, ACTUAL>, ACTUAL extends Date>
extends ObjectAssert<SELF, ACTUAL>
implements PositionComparisonAssertable<SELF, ACTUAL>,
YearAssertable<SELF, ACTUAL> {
    public DateAssert(ACTUAL actual) {
        super(actual);
    }

    protected DateAssert(Descriptor<?> descriptor, ACTUAL actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF isEqualTo(ACTUAL expected) {
        if (!PositionComparisonAssertable.IS_EQUAL_TO.test((Comparable)this.actual, (Comparable<?>)expected)) {
            this.setDefaultDescription("They are expected to be equal, but they aren't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DateAssert)this.self);
    }

    @Override
    public SELF isNotEqualTo(ACTUAL expected) {
        if (!PositionComparisonAssertable.IS_NOT_EQUAL_TO.test((Comparable)this.actual, (Comparable<?>)expected)) {
            this.setDefaultDescription("They are expected to be not equal, but they are.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DateAssert)this.self);
    }

    @Override
    public SELF isBefore(ACTUAL expected) {
        if (!PositionComparisonAssertable.IS_BEFORE.test((Comparable)this.actual, (Comparable<?>)expected)) {
            this.setDefaultDescription("It is expected to be before than the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DateAssert)this.self);
    }

    @Override
    public SELF isBeforeOrEqualTo(ACTUAL expected) {
        if (!PositionComparisonAssertable.IS_BEFORE_OR_EQUAL_TO.test((Comparable)this.actual, (Comparable<?>)expected)) {
            this.setDefaultDescription("It is expected to be before than or equal to the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DateAssert)this.self);
    }

    @Override
    public SELF isAfter(ACTUAL expected) {
        if (!PositionComparisonAssertable.IS_AFTER_THAN.test((Comparable)this.actual, (Comparable<?>)expected)) {
            this.setDefaultDescription("It is expected to be after than the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DateAssert)this.self);
    }

    @Override
    public SELF isAfterOrEqualTo(ACTUAL expected) {
        if (!PositionComparisonAssertable.IS_AFTER_THAN_OR_EQUAL_TO.test((Comparable)this.actual, (Comparable<?>)expected)) {
            this.setDefaultDescription("It is expected to be after than or equal to the other, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ACTUAL>("expected", expected));
            throw this.getException();
        }
        return (SELF)((DateAssert)this.self);
    }

    @Override
    public SELF isLeapYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.actual);
        int year = calendar.get(1);
        if (!Year.isLeap(year)) {
            this.setDefaultDescription("It is expected to be leap year, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((DateAssert)this.self);
    }

    @Override
    public SELF isNotLeapYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.actual);
        int year = calendar.get(1);
        if (Year.isLeap(year)) {
            this.setDefaultDescription("It is expected not to be leap year, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual));
            throw this.getException();
        }
        return (SELF)((DateAssert)this.self);
    }

    public InstantAssert<?> asInstant() {
        Instant instant = ((Date)this.actual).toInstant();
        class InstantAssertImpl
        extends InstantAssert<InstantAssertImpl> {
            InstantAssertImpl(Descriptor<?> descriptor, Instant actual) {
                super(descriptor, actual);
            }
        }
        return new InstantAssertImpl(this, instant);
    }

    public YearMonthAssert<?> asYearMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.actual);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        YearMonth yearMonth = YearMonth.of(year, month);
        class YearMonthAssertImpl
        extends YearMonthAssert<YearMonthAssertImpl> {
            YearMonthAssertImpl(Descriptor<?> descriptor, YearMonth actual) {
                super(descriptor, actual);
            }
        }
        return new YearMonthAssertImpl(this, yearMonth);
    }
}

