/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.RandomAccessIterationAssertable;
import io.github.imsejin.common.assertion.lang.IntegerAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.util.CollectionAssert;
import io.github.imsejin.common.util.ArrayUtils;
import java.util.AbstractMap;
import java.util.List;
import java.util.Objects;

public class ListAssert<SELF extends ListAssert<SELF, ACTUAL, ELEMENT>, ACTUAL extends List<? extends ELEMENT>, ELEMENT>
extends CollectionAssert<SELF, ACTUAL, ELEMENT>
implements RandomAccessIterationAssertable<SELF, ELEMENT> {
    public ListAssert(ACTUAL actual) {
        super(actual);
    }

    protected ListAssert(Descriptor<?> descriptor, ACTUAL actual) {
        super(descriptor, actual);
    }

    @Override
    @SafeVarargs
    public final SELF startsWith(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ListAssert)this.self);
        }
        if (((List)this.actual).size() < expected.length) {
            this.setDefaultDescription("It is expected to start with the given element(s), but it has fewer element(s) than that.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((List)this.actual).size()), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expected.length));
            throw this.getException();
        }
        for (int i = 0; i < expected.length; ++i) {
            ELEMENT item;
            Object element = ((List)this.actual).get(i);
            if (Objects.deepEquals(element, item = expected[i])) continue;
            this.setDefaultDescription("It is expected to start with the given element(s), but it contains unexpected element(s).", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry("unexpected", element));
            throw this.getException();
        }
        return (SELF)((ListAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF endsWith(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ListAssert)this.self);
        }
        if (((List)this.actual).size() < expected.length) {
            this.setDefaultDescription("It is expected to end with the given element(s), but it has fewer element(s) than that.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Integer>("actual.size", ((List)this.actual).size()), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry<String, Integer>("expected.size", expected.length));
            throw this.getException();
        }
        for (int i = 0; i < expected.length; ++i) {
            ELEMENT item;
            Object element = ((List)this.actual).get(((List)this.actual).size() - expected.length + i);
            if (Objects.deepEquals(element, item = expected[i])) continue;
            this.setDefaultDescription("It is expected to end with the given element(s), but it contains unexpected element(s).", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, ELEMENT[]>("expected", expected), new AbstractMap.SimpleEntry("unexpected", element));
            throw this.getException();
        }
        return null;
    }

    @Override
    public ObjectAssert<?, ELEMENT> asFirstElement() {
        return this.asElement(0);
    }

    @Override
    public ObjectAssert<?, ELEMENT> asLastElement() {
        return this.asElement(((List)this.actual).size() - 1);
    }

    @Override
    public ObjectAssert<?, ELEMENT> asElement(int index) {
        ((IntegerAssert)((IntegerAssert)Asserts.that(index).isNotNull()).isZeroOrPositive()).isLessThan(((List)this.actual).size());
        class ObjectAssertImpl
        extends ObjectAssert<ObjectAssertImpl, ELEMENT> {
            ObjectAssertImpl(Descriptor<?> descriptor, ELEMENT element) {
                super(descriptor, element);
            }
        }
        return new ObjectAssertImpl(this, ((List)this.actual).get(index));
    }
}

