/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.HolderAssertable;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import java.util.AbstractMap;
import java.util.Optional;

public class OptionalAssert<SELF extends OptionalAssert<SELF, VALUE>, VALUE>
extends ObjectAssert<SELF, Optional<VALUE>>
implements HolderAssertable<SELF, VALUE> {
    public OptionalAssert(Optional<VALUE> actual) {
        super(actual);
    }

    protected OptionalAssert(Descriptor<?> descriptor, Optional<VALUE> actual) {
        super(descriptor, actual);
    }

    @Override
    public SELF hasValue(VALUE expected) {
        Object value = ((Optional)this.actual).orElse(null);
        if (value == null || !value.equals(expected)) {
            this.setDefaultDescription("It is expected to have the given value, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Object>("actual.value", value), new AbstractMap.SimpleEntry<String, VALUE>("expected", expected));
            throw this.getException();
        }
        return (SELF)((OptionalAssert)this.self);
    }

    @Override
    public SELF doesNotHaveValue(VALUE expected) {
        Object value = ((Optional)this.actual).orElse(null);
        if (value != null && value.equals(expected)) {
            this.setDefaultDescription("It is expected not to have the given value, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Object>("actual.value", value), new AbstractMap.SimpleEntry<String, VALUE>("expected", expected));
            throw this.getException();
        }
        return (SELF)((OptionalAssert)this.self);
    }

    public SELF isPresent() {
        if (!((Optional)this.actual).isPresent()) {
            this.setDefaultDescription("It is expected to be present, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Object>("actual.value", ((Optional)this.actual).orElse(null)));
            throw this.getException();
        }
        return (SELF)((OptionalAssert)this.self);
    }

    public SELF isAbsent() {
        if (((Optional)this.actual).isPresent()) {
            this.setDefaultDescription("It is expected to be absent, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Object>("actual.value", ((Optional)this.actual).orElse(null)));
            throw this.getException();
        }
        return (SELF)((OptionalAssert)this.self);
    }
}

