/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util.concurrent.atomic;

import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.HolderAssertable;
import io.github.imsejin.common.assertion.lang.AbstractNumberAssert;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;

public class AtomicLongAssert<SELF extends AtomicLongAssert<SELF>>
extends AbstractNumberAssert<SELF, AtomicLong>
implements HolderAssertable<SELF, Long> {
    private static final AtomicLong ZERO = new AtomicLong(0L);

    public AtomicLongAssert(AtomicLong actual) {
        super(actual, ZERO, Comparator.comparingLong(AtomicLong::get));
    }

    protected AtomicLongAssert(Descriptor<?> descriptor, AtomicLong actual) {
        super(descriptor, actual, ZERO, Comparator.comparingLong(AtomicLong::get));
    }

    @Override
    public SELF hasValue(Long expected) {
        if (expected == null || ((AtomicLong)this.actual).get() != expected.longValue()) {
            this.setDefaultDescription("It is expected to have the given value, but it isn't.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AtomicLongAssert)this.self);
    }

    @Override
    public SELF doesNotHaveValue(Long expected) {
        if (expected != null && ((AtomicLong)this.actual).get() == expected.longValue()) {
            this.setDefaultDescription("It is expected not to have the given value, but it is.", new Object[0]);
            this.setDescriptionVariables(new AbstractMap.SimpleEntry<String, Object>("actual", this.actual), new AbstractMap.SimpleEntry<String, Long>("expected", expected));
            throw this.getException();
        }
        return (SELF)((AtomicLongAssert)this.self);
    }
}

