/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.constant;

import java.util.Locale;

public enum OS {
    LINUX,
    MAC,
    AIX,
    SOLARIS,
    WINDOWS,
    OTHER;

    private static final OS CURRENT_OS;

    public static OS getCurrentOS() {
        return CURRENT_OS;
    }

    public boolean isCurrentOS() {
        return this == CURRENT_OS;
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        OS os = osName.contains("linux") ? LINUX : (osName.contains("mac") ? MAC : (osName.contains("aix") ? AIX : (osName.contains("sunos") || osName.contains("solaris") ? SOLARIS : (osName.contains("win") ? WINDOWS : OTHER))));
        CURRENT_OS = os;
    }
}

