/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.io.finder;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.nio.file.PathAssert;
import io.github.imsejin.common.io.GzipResource;
import io.github.imsejin.common.io.Resource;
import io.github.imsejin.common.io.finder.ResourceFinder;
import io.github.imsejin.common.util.FilenameUtils;
import io.github.imsejin.common.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class GzipResourceFinder
implements ResourceFinder {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Resource> getResources(Path path) {
        ((PathAssert)((Descriptor)((PathAssert)((Descriptor)((PathAssert)((PathAssert)((PathAssert)Asserts.that(path).describedAs("Invalid path to find resources: {0}", path)).isNotNull()).describedAs("No such path exists: {0}", path)).exists()).describedAs("It is not a regular file: {0}", path)).isRegularFile()).describedAs("Cannot read file: {0}", path)).is(Files::isReadable);
        try (GzipCompressorInputStream in = new GzipCompressorInputStream(Files.newInputStream(path, new OpenOption[0]));){
            int offset;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[16384];
            while ((offset = in.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            String fileName = in.getMetaData().getFilename();
            if (StringUtils.isNullOrEmpty(fileName)) {
                String name = FilenameUtils.getName(path.toString());
                fileName = FilenameUtils.getBaseName(name);
            }
            long modifiedMilliTime = in.getMetaData().getModificationTime();
            byte[] bytes = out.toByteArray();
            GzipResource resource = new GzipResource(fileName, new ByteArrayInputStream(bytes), bytes.length, in.getCompressedCount(), modifiedMilliTime);
            List<Resource> list = Collections.singletonList(resource);
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read gzip compressor: " + path, e);
        }
    }
}

