/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.model.graph;

import io.github.imsejin.common.model.graph.Graph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UndirectedGraph<E>
implements Graph<E> {
    private final Map<E, Set<E>> adjacentVertexMap = new HashMap<E, Set<E>>();
    private final Set<Edge<E>> edges = new HashSet<Edge<E>>();

    public UndirectedGraph() {
    }

    public UndirectedGraph(Graph<E> graph) {
        this();
        this.addAll(graph);
    }

    @Override
    public boolean addVertex(E e) {
        if (e == null || this.adjacentVertexMap.containsKey(e)) {
            return false;
        }
        this.adjacentVertexMap.put(e, new HashSet());
        return true;
    }

    @Override
    public boolean removeVertex(E e) {
        if (e == null || !this.adjacentVertexMap.containsKey(e)) {
            return false;
        }
        this.adjacentVertexMap.remove(e);
        for (Set<E> them : this.adjacentVertexMap.values()) {
            them.remove(e);
        }
        this.edges.removeIf(edge -> ((Edge)edge).vertex1.equals(e) || ((Edge)edge).vertex2.equals(e));
        return true;
    }

    @Override
    public boolean addEdge(E e1, E e2) {
        if (e1 == null || e2 == null || e1.equals(e2)) {
            return false;
        }
        Set<E> v1 = this.adjacentVertexMap.get(e1);
        Set<E> v2 = this.adjacentVertexMap.get(e2);
        if (v1 == null || v2 == null) {
            return false;
        }
        Edge<E> edge = new Edge<E>(e1, e2);
        if (this.edges.contains(edge)) {
            return false;
        }
        v1.add(e2);
        v2.add(e1);
        this.edges.add(edge);
        return true;
    }

    @Override
    public boolean removeEdge(E e1, E e2) {
        if (e1 == null || e2 == null || e1.equals(e2)) {
            return false;
        }
        Set<E> v1 = this.adjacentVertexMap.get(e1);
        Set<E> v2 = this.adjacentVertexMap.get(e2);
        if (v1 == null || v2 == null) {
            return false;
        }
        v1.remove(e2);
        v2.remove(e1);
        this.edges.remove(new Edge<E>(e1, e2));
        return true;
    }

    @Override
    public boolean addAll(Graph<E> graph) {
        Set<E> vertices = graph.getAllVertices();
        if (vertices.isEmpty()) {
            return false;
        }
        for (E e : vertices) {
            Set<E> oldbie = this.adjacentVertexMap.get(e);
            Set<E> newbie = graph.getAdjacentVertices(e);
            if (oldbie == null) {
                this.adjacentVertexMap.put(e, newbie);
            } else {
                oldbie.addAll(newbie);
            }
            for (E it : newbie) {
                this.edges.add(new Edge<E>(e, it));
            }
        }
        return true;
    }

    @Override
    public boolean containsVertex(E e) {
        return this.adjacentVertexMap.containsKey(e);
    }

    @Override
    public int getVertexSize() {
        return this.adjacentVertexMap.size();
    }

    @Override
    public int getPathLength() {
        return this.edges.size();
    }

    @Override
    public Set<E> getAllVertices() {
        return this.adjacentVertexMap.keySet();
    }

    @Override
    public Set<E> getAdjacentVertices(E e) {
        return this.adjacentVertexMap.get(e);
    }

    public String toString() {
        Set<Map.Entry<E, Set<E>>> entries = this.adjacentVertexMap.entrySet();
        StringBuilder sb = new StringBuilder("UndirectedGraph {");
        if (entries.isEmpty()) {
            return sb.append("}").toString();
        }
        sb.append('\n');
        int i = 0;
        for (Map.Entry<E, Set<E>> entry : entries) {
            sb.append("  ").append(entry.getKey()).append(": ").append(entry.getValue());
            if (i == entries.size() - 1) {
                sb.append("\n");
            } else {
                sb.append(",\n");
            }
            ++i;
        }
        return sb.append('}').toString();
    }

    public int hashCode() {
        return Objects.hash(this.adjacentVertexMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UndirectedGraph)) {
            return false;
        }
        UndirectedGraph that = (UndirectedGraph)o;
        return this.adjacentVertexMap.equals(that.adjacentVertexMap);
    }

    private static class Edge<E> {
        private final E vertex1;
        private final E vertex2;

        public Edge(E vertex1, E vertex2) {
            this.vertex1 = vertex1;
            this.vertex2 = vertex2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge that = (Edge)o;
            return this.vertex1.equals(that.vertex1) && this.vertex2.equals(that.vertex2) || this.vertex1.equals(that.vertex2) && this.vertex2.equals(that.vertex1);
        }

        public int hashCode() {
            return Objects.hash(this.vertex1.hashCode() + this.vertex2.hashCode());
        }
    }
}

