/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.model.graph.traverse;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.model.graph.Graph;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;

public class BreadthFirstIterator<E>
implements Iterator<E> {
    private final Set<E> visited = new HashSet();
    private final Queue<E> queue = new ArrayDeque();
    private final Graph<E> graph;

    public BreadthFirstIterator(Graph<E> graph, E root) {
        ((ObjectAssert)Asserts.that(graph).describedAs("BreadthFirstIterator.graph is not allowed to be null", new Object[0])).isNotNull();
        ((ObjectAssert)((Descriptor)((ObjectAssert)Asserts.that(root).describedAs("BreadthFirstIterator.root is not allowed to be null", new Object[0])).isNotNull()).describedAs("BreadthFirstIterator.root must be in graph as a vertex: '{0}'", root)).is(graph::containsVertex);
        this.graph = graph;
        this.queue.offer(root);
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("BreadthFirstIterator has no more elements");
        }
        E vertex = this.queue.poll();
        this.visited.add(vertex);
        for (E v : this.graph.getAdjacentVertices(vertex)) {
            if (this.visited.contains(v)) continue;
            this.queue.offer(v);
            this.visited.add(v);
        }
        return vertex;
    }

    public static <E> void traverse(Graph<E> graph, E root, Consumer<E> consumer) {
        ((ObjectAssert)Asserts.that(graph).describedAs("BreadthFirstIterator.graph is not allowed to be null", new Object[0])).isNotNull();
        ((ObjectAssert)((Descriptor)((ObjectAssert)Asserts.that(root).describedAs("BreadthFirstIterator.root is not allowed to be null", new Object[0])).isNotNull()).describedAs("BreadthFirstIterator.root must be in graph as a vertex: '{0}'", root)).is(graph::containsVertex);
        LinkedHashSet visited = new LinkedHashSet();
        ArrayDeque<E> queue = new ArrayDeque<E>();
        queue.add(root);
        while (!queue.isEmpty()) {
            Object vertex = queue.poll();
            if (visited.contains(vertex)) continue;
            consumer.accept(vertex);
            visited.add(vertex);
            for (E v : graph.getAdjacentVertices(vertex)) {
                if (visited.contains(v)) continue;
                queue.offer(v);
            }
        }
    }
}

