/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.util.ClassUtils;
import jakarta.validation.constraints.Null;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ArrayUtils {
    public static final Map<Class<?>, Object> EMPTY_ARRAY_MAP;

    @ExcludeFromGeneratedJacocoReport
    private ArrayUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static boolean isNullOrEmpty(Object array) {
        return array == null || Array.getLength(array) == 0;
    }

    public static boolean exists(Object array) {
        return !ArrayUtils.isNullOrEmpty(array);
    }

    @Null
    public static Object wrap(@Null Object array) {
        if (array == null) {
            return null;
        }
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType == null) {
            return array;
        }
        int length = Array.getLength(array);
        Class<?> wrapped = ClassUtils.wrap(componentType);
        Object wrappedArray = Array.newInstance(wrapped, length);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (element == null || element.getClass().isArray()) {
                element = ArrayUtils.wrap(element);
            }
            Array.set(wrappedArray, i, element);
        }
        return wrappedArray;
    }

    @Null
    public static Object unwrap(@Null Object array) {
        if (array == null) {
            return null;
        }
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType == null) {
            return array;
        }
        int length = Array.getLength(array);
        Class<?> primitive = ClassUtils.unwrap(componentType);
        Object primitiveArray = Array.newInstance(primitive, length);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (element == null || element.getClass().isArray()) {
                element = ArrayUtils.unwrap(element);
            }
            Array.set(primitiveArray, i, element);
        }
        return primitiveArray;
    }

    public static String toString(@Null Object array) {
        if (array == null) {
            return "null";
        }
        Class<?> clazz = array.getClass();
        if (clazz.isArray()) {
            if (array instanceof Object[]) {
                return Arrays.deepToString((Object[])array);
            }
            Class<?> componentType = clazz.getComponentType();
            if (componentType == Boolean.TYPE) {
                return Arrays.toString((boolean[])array);
            }
            if (componentType == Byte.TYPE) {
                return Arrays.toString((byte[])array);
            }
            if (componentType == Short.TYPE) {
                return Arrays.toString((short[])array);
            }
            if (componentType == Character.TYPE) {
                return Arrays.toString((char[])array);
            }
            if (componentType == Integer.TYPE) {
                return Arrays.toString((int[])array);
            }
            if (componentType == Long.TYPE) {
                return Arrays.toString((long[])array);
            }
            if (componentType == Float.TYPE) {
                return Arrays.toString((float[])array);
            }
            if (componentType == Double.TYPE) {
                return Arrays.toString((double[])array);
            }
        } else {
            if (array instanceof Path) {
                return array.toString();
            }
            if (array instanceof Iterable) {
                Iterator iterator = ((Iterable)array).iterator();
                StringBuilder sb = new StringBuilder("[");
                if (iterator.hasNext()) {
                    sb.append(ArrayUtils.toString(iterator.next()));
                    while (iterator.hasNext()) {
                        sb.append(", ").append(ArrayUtils.toString(iterator.next()));
                    }
                }
                sb.append("]");
                return sb.toString();
            }
            if (array instanceof Map) {
                Iterator iterator = ((Map)array).entrySet().iterator();
                StringBuilder sb = new StringBuilder("{");
                if (iterator.hasNext()) {
                    Map.Entry e0 = iterator.next();
                    sb.append(ArrayUtils.toString(e0.getKey())).append('=').append(ArrayUtils.toString(e0.getValue()));
                    while (iterator.hasNext()) {
                        Map.Entry e1 = iterator.next();
                        sb.append(", ").append(ArrayUtils.toString(e1.getKey())).append('=').append(ArrayUtils.toString(e1.getValue()));
                    }
                }
                sb.append("}");
                return sb.toString();
            }
        }
        return array.toString();
    }

    public static int hashCode(@Null Object array) {
        if (array == null) {
            return 0;
        }
        Class<?> clazz = array.getClass();
        if (clazz.isArray()) {
            if (array instanceof Object[]) {
                return Arrays.deepHashCode((Object[])array);
            }
            Class<?> componentType = clazz.getComponentType();
            if (componentType == Boolean.TYPE) {
                return Arrays.hashCode((boolean[])array);
            }
            if (componentType == Byte.TYPE) {
                return Arrays.hashCode((byte[])array);
            }
            if (componentType == Short.TYPE) {
                return Arrays.hashCode((short[])array);
            }
            if (componentType == Character.TYPE) {
                return Arrays.hashCode((char[])array);
            }
            if (componentType == Integer.TYPE) {
                return Arrays.hashCode((int[])array);
            }
            if (componentType == Long.TYPE) {
                return Arrays.hashCode((long[])array);
            }
            if (componentType == Float.TYPE) {
                return Arrays.hashCode((float[])array);
            }
            if (componentType == Double.TYPE) {
                return Arrays.hashCode((double[])array);
            }
        }
        return array.hashCode();
    }

    public static Object[] prepend(Object[] src, Object ... elements) {
        if (ArrayUtils.isNullOrEmpty(elements)) {
            return src;
        }
        Object[] array = new Object[elements.length + src.length];
        System.arraycopy(elements, 0, array, 0, elements.length);
        if (ArrayUtils.exists(src)) {
            System.arraycopy(src, 0, array, elements.length, src.length);
        }
        return array;
    }

    public static Object[] append(Object[] src, Object ... elements) {
        if (ArrayUtils.isNullOrEmpty(elements)) {
            return src;
        }
        Object[] array = new Object[src.length + elements.length];
        if (ArrayUtils.exists(src)) {
            System.arraycopy(src, 0, array, 0, src.length);
        }
        System.arraycopy(elements, 0, array, src.length, elements.length);
        return array;
    }

    public static Class<?> resolveArrayType(Class<?> type, int dimension) {
        for (int i = 0; i < dimension; ++i) {
            type = Array.newInstance(type, 0).getClass();
        }
        return type;
    }

    public static Class<?> resolveActualComponentType(Class<?> type) {
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    public static int dimensionOf(Class<?> type) {
        int dimension = 0;
        while (type.isArray()) {
            type = type.getComponentType();
            ++dimension;
        }
        return dimension;
    }

    static {
        HashMap<Class<Object>, Object[]> cache = new HashMap<Class<Object>, Object[]>();
        cache.put(Boolean.TYPE, new boolean[0]);
        cache.put(Byte.TYPE, new byte[0]);
        cache.put(Short.TYPE, new short[0]);
        cache.put(Character.TYPE, new char[0]);
        cache.put(Integer.TYPE, new int[0]);
        cache.put(Long.TYPE, new long[0]);
        cache.put(Float.TYPE, new float[0]);
        cache.put(Double.TYPE, new double[0]);
        cache.put(Void.class, new Void[0]);
        cache.put(Boolean.class, new Boolean[0]);
        cache.put(Byte.class, new Byte[0]);
        cache.put(Short.class, new Short[0]);
        cache.put(Character.class, new Character[0]);
        cache.put(Integer.class, new Integer[0]);
        cache.put(Long.class, new Long[0]);
        cache.put(Float.class, new Float[0]);
        cache.put(Double.class, new Double[0]);
        EMPTY_ARRAY_MAP = Collections.unmodifiableMap(cache);
    }
}

