/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.constant.DateType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.zone.ZoneRules;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;

public final class DateTimeUtils {
    private static final Randoms randoms = new Randoms(ThreadLocalRandom.current());

    @ExcludeFromGeneratedJacocoReport
    private DateTimeUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static boolean validate(String date) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateType.DATE.getPattern(), Locale.getDefault());
            dateFormat.setLenient(false);
            dateFormat.parse(date.replace("-", ""));
            return true;
        }
        catch (ParseException ignored) {
            return false;
        }
    }

    public static boolean validate(String date, DayOfWeek dayOfWeek) {
        if (!DateTimeUtils.validate(date)) {
            return false;
        }
        LocalDate localDate = LocalDate.parse(date = date.replace("-", ""), DateType.DATE.getFormatter());
        return localDate.getDayOfWeek() == dayOfWeek;
    }

    public static ZoneOffset getSystemDefaultZoneOffset() {
        ZoneId zone = ZoneId.systemDefault();
        ZoneRules rules = zone.getRules();
        return rules.getOffset(LocalDateTime.now(zone));
    }

    public static LocalDateTime random(ChronoLocalDateTime<? extends ChronoLocalDate> start, ChronoLocalDateTime<? extends ChronoLocalDate> end) {
        return randoms.nextDateTime(start, end);
    }

    public static LocalDateTime random(ChronoLocalDateTime<? extends ChronoLocalDate> start, ChronoLocalDateTime<? extends ChronoLocalDate> end, ZoneOffset offset) {
        return randoms.nextDateTime(start, end, offset);
    }

    private static class Randoms {
        private final ThreadLocalRandom random;

        private Randoms(ThreadLocalRandom random) {
            this.random = random;
        }

        public LocalDateTime nextDateTime(ChronoLocalDateTime<? extends ChronoLocalDate> start, ChronoLocalDateTime<? extends ChronoLocalDate> end) {
            return this.nextDateTime(start, end, DateTimeUtils.getSystemDefaultZoneOffset());
        }

        public LocalDateTime nextDateTime(ChronoLocalDateTime<? extends ChronoLocalDate> start, ChronoLocalDateTime<? extends ChronoLocalDate> end, ZoneOffset offset) {
            long randomSeconds = this.random.nextLong(start.toEpochSecond(offset), end.toEpochSecond(offset));
            return LocalDateTime.ofInstant(Instant.ofEpochSecond(randomSeconds), offset);
        }
    }
}

