/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import java.math.BigInteger;

public final class MathUtils {
    @ExcludeFromGeneratedJacocoReport
    private MathUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static BigInteger fibonacci(long number) {
        BigInteger a = BigInteger.valueOf(0L);
        BigInteger b = BigInteger.valueOf(1L);
        for (long i = 0L; i < number; ++i) {
            BigInteger temp = a.add(b);
            a = b;
            b = temp;
        }
        return a;
    }

    public static BigInteger factorial(long number) {
        BigInteger result = BigInteger.valueOf(1L);
        for (long factor = 2L; factor <= number; ++factor) {
            result = result.multiply(BigInteger.valueOf(factor));
        }
        return result;
    }

    public static int gcd(int a, int b) {
        if (b == 0) {
            return a;
        }
        return MathUtils.gcd(b, Math.floorMod(a, b));
    }

    public static boolean isPrime(long number) {
        if (number < 2L) {
            return false;
        }
        if (number == 2L) {
            return true;
        }
        if (number % 2L == 0L) {
            return false;
        }
        long i = 3L;
        while (i * i <= number) {
            if (number % i == 0L) {
                return false;
            }
            i += 2L;
        }
        return true;
    }

    public static double ceil(double amount, int scale) {
        double compensator = Math.pow(10.0, scale);
        return Math.ceil(amount * compensator) / compensator;
    }

    public static double round(double amount, int scale) {
        double compensator = Math.pow(10.0, scale);
        return (double)Math.round(amount * compensator) / compensator;
    }

    public static double floor(double amount, int scale) {
        double compensator = Math.pow(10.0, scale);
        return Math.floor(amount * compensator) / compensator;
    }

    public static boolean isOdd(long number) {
        return (number & 1L) == 1L;
    }

    public static boolean isOdd(BigInteger bigInt) {
        return bigInt.testBit(0);
    }
}

