/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.util.ArrayUtils;
import io.github.imsejin.common.util.StringUtils;
import java.text.MessageFormat;
import java.util.function.Function;

public abstract class Descriptor<SELF extends Descriptor<SELF>> {
    protected final SELF self;
    private String description;
    private Object[] arguments;
    private Function<String, ? extends RuntimeException> function = IllegalArgumentException::new;

    protected Descriptor() {
        this.self = this;
    }

    protected static void merge(Descriptor<?> source, Descriptor<?> target) {
        target.description = source.description;
        target.arguments = source.arguments;
        target.function = source.function;
    }

    public final SELF as(String description, Object ... args) {
        this.description = description;
        this.arguments = args;
        return this.self;
    }

    public final SELF exception(Function<String, ? extends RuntimeException> function) {
        this.function = function;
        return this.self;
    }

    protected final RuntimeException getException() {
        return this.function.apply(this.getMessage());
    }

    protected final void setDefaultDescription(String description, Object ... args) {
        if (!StringUtils.isNullOrEmpty(this.description)) {
            return;
        }
        this.description = description;
        this.arguments = args;
    }

    private String getMessage() {
        if (StringUtils.isNullOrEmpty(this.description)) {
            return "";
        }
        String pattern = this.description.replace("'", "''");
        MessageFormat messageFormat = new MessageFormat(pattern);
        String[] strings = new String[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            Object argument = this.arguments[i];
            strings[i] = ArrayUtils.toString(argument);
        }
        return messageFormat.format(strings);
    }

    @Deprecated
    @ExcludeFromGeneratedJacocoReport
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

