/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.io;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.NumberAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import io.github.imsejin.common.util.FilenameUtils;
import java.io.File;

public abstract class AbstractFileAssert<SELF extends AbstractFileAssert<SELF, ACTUAL>, ACTUAL extends File>
extends ObjectAssert<SELF, ACTUAL> {
    protected AbstractFileAssert(ACTUAL actual) {
        super(actual);
    }

    public SELF exists() {
        if (!((File)this.actual).exists()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isEmpty() {
        if (((File)this.actual).length() > 0L) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isNotEmpty() {
        if (((File)this.actual).length() == 0L) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isFile() {
        if (!((File)this.actual).isFile()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isNotFile() {
        if (((File)this.actual).isFile()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isDirectory() {
        if (!((File)this.actual).isDirectory()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isNotDirectory() {
        if (((File)this.actual).isDirectory()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isAbsolute() {
        if (!((File)this.actual).isAbsolute()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isRelative() {
        if (((File)this.actual).isAbsolute()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isHidden() {
        if (!((File)this.actual).isHidden()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isNotHidden() {
        if (((File)this.actual).isHidden()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF canRead() {
        if (!((File)this.actual).canRead()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF canNotRead() {
        if (((File)this.actual).canRead()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF canWrite() {
        if (!((File)this.actual).canWrite()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF canNotWrite() {
        if (((File)this.actual).canWrite()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF canExecute() {
        if (!((File)this.actual).canExecute()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF canNotExecute() {
        if (((File)this.actual).canExecute()) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF hasLengthOf(ACTUAL expected) {
        return this.hasLengthOf(((File)expected).length());
    }

    public SELF hasLengthOf(long expected) {
        if (((File)this.actual).length() != expected) {
            this.setDefaultDescription("It is expected to be the same length, but it isn't. (expected: '{0}', actual: '{1}')", expected, ((File)this.actual).length());
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isLargerThan(ACTUAL expected) {
        return this.isLargerThan(((File)expected).length());
    }

    public SELF isLargerThan(long expected) {
        if (((File)this.actual).length() <= expected) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF isSmallerThan(ACTUAL expected) {
        return this.isSmallerThan(((File)expected).length());
    }

    public SELF isSmallerThan(long expected) {
        if (((File)this.actual).length() >= expected) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF hasName(String expected) {
        if (!((File)this.actual).getName().equals(expected)) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public SELF hasExtension(String expected) {
        if (!FilenameUtils.getExtension(((File)this.actual).getName()).equals(expected)) {
            throw this.getException();
        }
        return (SELF)((AbstractFileAssert)this.self);
    }

    public NumberAssert<?, Long> asLength() {
        NumberAssert<?, Long> assertion = Asserts.that(((File)this.actual).length());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public StringAssert<?> asName() {
        StringAssert<?> assertion = Asserts.that(((File)this.actual).getName());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

