/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.IterationAssertable;
import io.github.imsejin.common.assertion.composition.RandomAccessIterationAssertable;
import io.github.imsejin.common.assertion.lang.NumberAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.util.ArrayUtils;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;

public class ArrayAssert<SELF extends ArrayAssert<SELF, ELEMENT>, ELEMENT>
extends ObjectAssert<SELF, ELEMENT[]>
implements IterationAssertable<SELF, ELEMENT[], ELEMENT>,
RandomAccessIterationAssertable<SELF, ELEMENT[], ELEMENT> {
    public ArrayAssert(ELEMENT[] actual) {
        super(actual);
    }

    @Override
    public SELF isEmpty() {
        if (((Object[])this.actual).length > 0) {
            this.setDefaultDescription("It is expected to be empty, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF hasElement() {
        if (((Object[])this.actual).length == 0) {
            this.setDefaultDescription("It is expected to have element, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    public SELF hasLengthOf(int expected) {
        if (((Object[])this.actual).length != expected) {
            this.setDefaultDescription("It is expected to be the same length, but it isn't. (expected: '{0}', actual: '{1}')", expected, ((Object[])this.actual).length);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    public SELF isSameLength(Object[] expected) {
        if (expected == null || ((Object[])this.actual).length != expected.length) {
            this.setDefaultDescription("They are expected to be the same length, but they aren't. (expected: '{0}', actual: '{1}')", expected == null ? "null" : Integer.valueOf(expected.length), ((Object[])this.actual).length);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    public SELF isNotSameLength(Object[] expected) {
        if (expected == null || ((Object[])this.actual).length == expected.length) {
            this.setDefaultDescription("They are expected to be not the same length, but they are. (expected: '{0}', actual: '{1}')", expected == null ? "null" : Integer.valueOf(expected.length), ((Object[])this.actual).length);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF contains(ELEMENT expected) {
        for (Object element : (Object[])this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            return (SELF)((ArrayAssert)this.self);
        }
        this.setDefaultDescription("It is expected to contain the given element, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
        throw this.getException();
    }

    @Override
    public SELF doesNotContain(ELEMENT expected) {
        for (Object element : (Object[])this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            this.setDefaultDescription("It is expected not to contain the given element, but it is. (expected: '{0}', actual: '{1}', unexpected: '{2}')", expected, this.actual, element);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF containsNull() {
        for (Object element : (Object[])this.actual) {
            if (element != null) continue;
            return (SELF)((ArrayAssert)this.self);
        }
        this.setDefaultDescription("It is expected to contain null, but it isn't. (actual: '{0}')", this.actual);
        throw this.getException();
    }

    @Override
    public SELF doesNotContainNull() {
        for (Object element : (Object[])this.actual) {
            if (element != null) continue;
            this.setDefaultDescription("It is expected not to contain null, but it is. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF containsAny(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        for (ELEMENT item : expected) {
            for (Object element : (Object[])this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                return (SELF)((ArrayAssert)this.self);
            }
        }
        this.setDefaultDescription("It is expected to contain at least one of the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
        throw this.getException();
    }

    @Override
    public SELF containsAll(ELEMENT[] expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        block0: for (ELEMENT item : expected) {
            for (Object element : (Object[])this.actual) {
                if (Objects.deepEquals(element, item)) continue block0;
            }
            this.setDefaultDescription("It is expected to contain all the given elements, but it isn't. (expected: '{0}', actual: '{1}', missing: '{2}')", expected, this.actual, item);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF doesNotContainAll(ELEMENT[] expected) {
        if (((Object[])this.actual).length == 0 || ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        for (ELEMENT item : expected) {
            for (Object element : (Object[])this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                this.setDefaultDescription("It is expected not to contain all the given elements, but it is. (expected: '{0}', actual: '{1}')", expected, this.actual);
                throw this.getException();
            }
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF containsOnly(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        block0: for (ELEMENT ELEMENT : expected) {
            for (Object element : (Object[])this.actual) {
                if (Objects.deepEquals(element, ELEMENT)) continue block0;
            }
            this.setDefaultDescription("It is expected to contain only the given element(s), but it doesn't contain some element(s). (expected: '{0}', actual: '{1}', missing: '{2}')", expected, this.actual, ELEMENT);
            throw this.getException();
        }
        block2: for (Object object : (Object[])this.actual) {
            for (ELEMENT item : expected) {
                if (Objects.deepEquals(object, item)) continue block2;
            }
            this.setDefaultDescription("It is expected to contain only the given element(s), but it contains unexpected element(s). (expected: '{0}', actual: '{1}', unexpected: '{2}')", expected, this.actual, object);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF containsOnlyNulls() {
        if (((Object[])this.actual).length == 0) {
            this.setDefaultDescription("It is expected to contain only null elements, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        for (Object element : (Object[])this.actual) {
            if (element == null) continue;
            this.setDefaultDescription("It is expected to contain only null elements, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF doesNotHaveDuplicates() {
        if (((Object[])this.actual).length == 0 || ((Object[])this.actual).length == 1) {
            return (SELF)((ArrayAssert)this.self);
        }
        TreeSet<Object> noDuplicates = new TreeSet<Object>((o1, o2) -> {
            if (Objects.deepEquals(o1, o2)) {
                return 0;
            }
            return ArrayUtils.hashCode(o1) < ArrayUtils.hashCode(o2) ? -1 : 1;
        });
        for (Object element : (Object[])this.actual) {
            if (noDuplicates.contains(element)) {
                this.setDefaultDescription("It is expected not to have duplicated elements, but it is. (actual: '{0}', duplicated: '{1}')", this.actual, element);
                throw this.getException();
            }
            noDuplicates.add(element);
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF anyMatch(Predicate<ELEMENT> expected) {
        for (Object element : (Object[])this.actual) {
            if (!expected.test(element)) continue;
            return (SELF)((ArrayAssert)this.self);
        }
        this.setDefaultDescription("It is expected to match the given condition with its any elements, but it isn't. (actual: '{0}')", this.actual);
        throw this.getException();
    }

    @Override
    public SELF allMatch(Predicate<ELEMENT> expected) {
        if (((Object[])this.actual).length == 0) {
            this.setDefaultDescription("It is expected to match the given condition with its all elements, but it isn't. (actual: '{0}', unexpected: '{1}')", this.actual, "");
            throw this.getException();
        }
        for (Object element : (Object[])this.actual) {
            if (expected.test(element)) continue;
            this.setDefaultDescription("It is expected to match the given condition with its all elements, but it isn't. (actual: '{0}', unexpected: '{1}')", this.actual, element);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    public SELF noneMatch(Predicate<ELEMENT> expected) {
        for (Object element : (Object[])this.actual) {
            if (!expected.test(element)) continue;
            this.setDefaultDescription("It is expected not to match the given condition with its all elements, but it is. (actual: '{0}', unexpected: '{1}')", this.actual, element);
            throw this.getException();
        }
        return (SELF)((ArrayAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF startsWith(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        if (((Object[])this.actual).length < expected.length) {
            this.setDefaultDescription("It is expected to start with the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        for (int i = 0; i < expected.length; ++i) {
            Object element = ((Object[])this.actual)[i];
            ELEMENT item = expected[i];
            if (Objects.deepEquals(element, item)) continue;
            this.setDefaultDescription("It is expected to start with the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return null;
    }

    @Override
    @SafeVarargs
    public final SELF endsWith(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ArrayAssert)this.self);
        }
        if (((Object[])this.actual).length < expected.length) {
            this.setDefaultDescription("It is expected to end with the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        for (int i = 0; i < expected.length; ++i) {
            Object element = ((Object[])this.actual)[((Object[])this.actual).length - expected.length + i];
            ELEMENT item = expected[i];
            if (Objects.deepEquals(element, item)) continue;
            this.setDefaultDescription("It is expected to end with the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return null;
    }

    public NumberAssert<?, Integer> asLength() {
        NumberAssert<?, Integer> assertion = Asserts.that(((Object[])this.actual).length);
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

