/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.NumberAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;

public class CharSequenceAssert<SELF extends CharSequenceAssert<SELF, ACTUAL>, ACTUAL extends CharSequence>
extends ObjectAssert<SELF, ACTUAL> {
    public CharSequenceAssert(ACTUAL actual) {
        super(actual);
    }

    public SELF isEmpty() {
        if (((CharSequence)this.actual).length() > 0) {
            this.setDefaultDescription("It is expected to be empty, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    public SELF isNotEmpty() {
        if (((CharSequence)this.actual).length() <= 0) {
            this.setDefaultDescription("It is expected to be not empty, but it is. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    public SELF hasLengthOf(int expected) {
        if (((CharSequence)this.actual).length() != expected) {
            this.setDefaultDescription("It is expected to have the same length, but it isn't. (expected: '{0}', actual: '{1}')", expected, ((CharSequence)this.actual).length());
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    public SELF isSameLength(ACTUAL expected) {
        if (expected == null || ((CharSequence)this.actual).length() != expected.length()) {
            this.setDefaultDescription("It is expected to have the same length, but it isn't. (expected: '{0}', actual: '{1}')", expected == null ? "null" : Integer.valueOf(expected.length()), ((CharSequence)this.actual).length());
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    public SELF isNotSameLength(ACTUAL expected) {
        if (expected == null || ((CharSequence)this.actual).length() == expected.length()) {
            this.setDefaultDescription("It is expected not to have the same length, but it is. (expected: '{0}', actual: '{1}')", expected == null ? "null" : Integer.valueOf(expected.length()), ((CharSequence)this.actual).length());
            throw this.getException();
        }
        return (SELF)((CharSequenceAssert)this.self);
    }

    public NumberAssert<?, Integer> asLength() {
        NumberAssert<?, Integer> assertion = Asserts.that(((CharSequence)this.actual).length());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

