/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.lang.ObjectAssert;

public class CharacterAssert<SELF extends CharacterAssert<SELF>>
extends ObjectAssert<SELF, Character> {
    public CharacterAssert(Character actual) {
        super(actual);
    }

    public SELF isGreaterThan(Character expected) {
        if (((Character)this.actual).charValue() <= expected.charValue()) {
            this.setDefaultDescription("It is expected to be greater than the other, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isGreaterThanOrEqualTo(Character expected) {
        if (((Character)this.actual).charValue() < expected.charValue()) {
            this.setDefaultDescription("It is expected to be greater than or equal to the other, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isLessThan(Character expected) {
        if (((Character)this.actual).charValue() >= expected.charValue()) {
            this.setDefaultDescription("It is expected to be less than the other, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isLessThanOrEqualTo(Character expected) {
        if (((Character)this.actual).charValue() > expected.charValue()) {
            this.setDefaultDescription("It is expected to be less than or equal to the other, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isDigit() {
        if (!Character.isDigit(((Character)this.actual).charValue())) {
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isLetter() {
        if (!Character.isLetter(((Character)this.actual).charValue())) {
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isLetterOrDigit() {
        if (!Character.isLetterOrDigit(((Character)this.actual).charValue())) {
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isUpperCase() {
        if (!Character.isUpperCase(((Character)this.actual).charValue())) {
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isLowerCase() {
        if (!Character.isLowerCase(((Character)this.actual).charValue())) {
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isAlphabetic() {
        if (!Character.isAlphabetic(((Character)this.actual).charValue())) {
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isSpaceChar() {
        if (!Character.isSpaceChar(((Character)this.actual).charValue())) {
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }

    public SELF isWhitespace() {
        if (!Character.isWhitespace(((Character)this.actual).charValue())) {
            throw this.getException();
        }
        return (SELF)((CharacterAssert)this.self);
    }
}

