/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.lang.PackageAssert;
import io.github.imsejin.common.util.ClassUtils;
import java.lang.reflect.Modifier;

public class ClassAssert<SELF extends ClassAssert<SELF, T>, T>
extends ObjectAssert<SELF, Class<?>> {
    public ClassAssert(Class<T> actual) {
        super(actual);
    }

    public SELF isTypeOf(Object expected) {
        if (!ClassUtils.wrap((Class)this.actual).isInstance(expected)) {
            this.setDefaultDescription("It is expected to be type of the instance, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isNotTypeOf(Object expected) {
        if (ClassUtils.wrap((Class)this.actual).isInstance(expected)) {
            this.setDefaultDescription("It is expected not to be type of the instance, but it is. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isAssignableFrom(Class<?> expected) {
        if (!((Class)this.actual).isAssignableFrom(expected)) {
            this.setDefaultDescription("It is expected to be assignable from the given type, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isSuperclassOf(Class<?> expected) {
        if (this.actual != expected.getSuperclass()) {
            this.setDefaultDescription("It is expected to be superclass of the given type, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isSubclassOf(Class<?> expected) {
        if (((Class)this.actual).getSuperclass() != expected) {
            this.setDefaultDescription("It is expected to be subclass of the given type, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isPrimitive() {
        if (!((Class)this.actual).isPrimitive()) {
            this.setDefaultDescription("It is expected to be primitive, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isInterface() {
        if (!((Class)this.actual).isInterface()) {
            this.setDefaultDescription("It is expected to be interface, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isAnnotation() {
        if (!((Class)this.actual).isAnnotation()) {
            this.setDefaultDescription("It is expected to be annotation, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isFinalClass() {
        if (!Modifier.isFinal(((Class)this.actual).getModifiers())) {
            this.setDefaultDescription("It is expected to be final class, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isAbstractClass() {
        if (!ClassUtils.isAbstractClass((Class)this.actual)) {
            this.setDefaultDescription("It is expected to be abstract class, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isAnonymousClass() {
        if (!((Class)this.actual).isAnonymousClass()) {
            this.setDefaultDescription("It is expected to be anonymous class, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isEnum() {
        if (!ClassUtils.isEnumOrEnumConstant((Class)this.actual)) {
            this.setDefaultDescription("It is expected to be enum, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isArray() {
        if (!((Class)this.actual).isArray()) {
            this.setDefaultDescription("It is expected to be array, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isMemberClass() {
        if (!((Class)this.actual).isMemberClass()) {
            this.setDefaultDescription("It is expected to be member class, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public SELF isLocalClass() {
        if (!((Class)this.actual).isLocalClass()) {
            this.setDefaultDescription("It is expected to be local class, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ClassAssert)this.self);
    }

    public ClassAssert<?, ?> asSuperclass() {
        ClassAssert assertion = Asserts.that(((Class)this.actual).getSuperclass());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public PackageAssert<?> asPackage() {
        PackageAssert<?> assertion = Asserts.that(((Class)this.actual).getPackage());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

