/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.lang.DoubleAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public class NumberAssert<SELF extends NumberAssert<SELF, NUMBER>, NUMBER extends Number>
extends ObjectAssert<SELF, NUMBER> {
    private final NUMBER zero;

    public NumberAssert(NUMBER actual) {
        super(actual);
        this.zero = NumberAssert.toNumber(BigInteger.ZERO, actual.getClass());
    }

    private static <N extends Number> N toNumber(N number, Class<N> numberType) {
        if (numberType == Byte.class) {
            return (N)Byte.valueOf(number.byteValue());
        }
        if (numberType == Short.class) {
            return (N)Short.valueOf(number.shortValue());
        }
        if (numberType == Integer.class) {
            return (N)Integer.valueOf(number.intValue());
        }
        if (numberType == Long.class) {
            return (N)Long.valueOf(number.longValue());
        }
        if (numberType == Float.class) {
            return (N)Float.valueOf(number.floatValue());
        }
        if (numberType == Double.class) {
            return (N)Double.valueOf(number.doubleValue());
        }
        if (numberType == BigInteger.class) {
            return (N)BigInteger.valueOf(number.longValue());
        }
        if (numberType == BigDecimal.class) {
            return (N)BigDecimal.valueOf(number.doubleValue());
        }
        throw new UnsupportedOperationException("NumberAssert doesn't support the type: " + numberType);
    }

    public SELF isGreaterThan(NUMBER expected) {
        if (((Comparable)((Object)((Number)this.actual))).compareTo(expected) <= 0) {
            this.setDefaultDescription("It is expected to be greater than the other, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((NumberAssert)this.self);
    }

    public SELF isGreaterThanOrEqualTo(NUMBER expected) {
        if (((Comparable)((Object)((Number)this.actual))).compareTo(expected) < 0) {
            this.setDefaultDescription("It is expected to be greater than or equal to the other, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((NumberAssert)this.self);
    }

    public SELF isLessThan(NUMBER expected) {
        if (((Comparable)((Object)((Number)this.actual))).compareTo(expected) >= 0) {
            this.setDefaultDescription("It is expected to be less than the other, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((NumberAssert)this.self);
    }

    public SELF isLessThanOrEqualTo(NUMBER expected) {
        if (((Comparable)((Object)((Number)this.actual))).compareTo(expected) > 0) {
            this.setDefaultDescription("It is expected to be less than or equal to the other, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((NumberAssert)this.self);
    }

    public SELF isPositive() {
        if (((Comparable)((Object)((Number)this.actual))).compareTo(this.zero) <= 0) {
            this.setDefaultDescription("It is expected to be positive, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((NumberAssert)this.self);
    }

    public SELF isZeroOrPositive() {
        if (((Comparable)((Object)((Number)this.actual))).compareTo(this.zero) < 0) {
            this.setDefaultDescription("It is expected to be zero or positive, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((NumberAssert)this.self);
    }

    public SELF isNegative() {
        if (((Comparable)((Object)((Number)this.actual))).compareTo(this.zero) >= 0) {
            this.setDefaultDescription("It is expected to be negative, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((NumberAssert)this.self);
    }

    public SELF isZeroOrNegative() {
        if (((Comparable)((Object)((Number)this.actual))).compareTo(this.zero) > 0) {
            this.setDefaultDescription("It is expected to be zero or negative, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((NumberAssert)this.self);
    }

    public SELF isBetween(NUMBER startInclusive, NUMBER endInclusive) {
        return ((NumberAssert)this.isGreaterThanOrEqualTo(startInclusive)).isLessThanOrEqualTo(endInclusive);
    }

    public SELF isStrictlyBetween(NUMBER startExclusive, NUMBER endExclusive) {
        return ((NumberAssert)this.isGreaterThan(startExclusive)).isLessThan(endExclusive);
    }

    public SELF isCloseTo(NUMBER expected, double percentage) {
        boolean invalid;
        ((DoubleAssert)((DoubleAssert)Asserts.that(percentage).as("Error percentage must be zero or positive and less than 100, but it isn't: {0}", percentage)).isZeroOrPositive()).isLessThan(100.0);
        if (percentage == 0.0) {
            return (SELF)((NumberAssert)this.isEqualTo(expected));
        }
        if (Objects.deepEquals(this.actual, expected)) {
            return (SELF)((NumberAssert)this.self);
        }
        if (expected == null) {
            this.setDefaultDescription("It is expected to close to other, but it isn't. (expected: 'null', actual: '{0}')", this.actual);
            throw this.getException();
        }
        double $actual = ((Number)this.actual).doubleValue();
        double $expected = ((Number)expected).doubleValue();
        if (Double.isNaN($actual) || Double.isInfinite($actual) || Double.isNaN($expected) || Double.isInfinite($expected)) {
            this.setDefaultDescription("It is expected to close to other, but it isn't. (expected: '{0}', actual: '{1}')", String.valueOf(expected), String.valueOf(this.actual));
            throw this.getException();
        }
        double diff = Math.abs($actual - $expected);
        double errorRate = diff / $actual * 100.0;
        boolean bl = invalid = Double.isNaN(errorRate) || Double.isInfinite(errorRate);
        if (invalid || Math.abs(errorRate) > percentage) {
            this.setDefaultDescription("It is expected to close to other by less than {0}%, but difference was {1}%. (expected: '{2}', actual: '{3}')", BigDecimal.valueOf(percentage).stripTrailingZeros().toPlainString(), invalid ? Double.valueOf(errorRate) : BigDecimal.valueOf(errorRate).stripTrailingZeros().toPlainString(), BigDecimal.valueOf($expected).stripTrailingZeros().toPlainString(), BigDecimal.valueOf($actual).stripTrailingZeros().toPlainString());
            throw this.getException();
        }
        return (SELF)((NumberAssert)this.self);
    }
}

