/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.ClassAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import io.github.imsejin.common.util.ClassUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public class ObjectAssert<SELF extends ObjectAssert<SELF, ACTUAL>, ACTUAL>
extends Descriptor<SELF> {
    protected final ACTUAL actual;

    public ObjectAssert(ACTUAL actual) {
        this.actual = actual;
    }

    public SELF isNull() {
        if (this.actual != null) {
            this.setDefaultDescription("It is expected to be null, but not null. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isNotNull() {
        if (this.actual == null) {
            this.setDefaultDescription("It is expected to be not null, but null. (actual: 'null')", new Object[0]);
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isSameAs(ACTUAL expected) {
        if (this.actual != expected) {
            this.setDefaultDescription("They are expected to be the same, but they aren't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isNotSameAs(ACTUAL expected) {
        if (this.actual == expected) {
            this.setDefaultDescription("They are expected to be not the same, but they are. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isEqualTo(ACTUAL expected) {
        if (!Objects.deepEquals(this.actual, expected)) {
            this.setDefaultDescription("They are expected to be equal, but they aren't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isNotEqualTo(ACTUAL expected) {
        if (Objects.deepEquals(this.actual, expected)) {
            this.setDefaultDescription("They are expected to be not equal, but they are. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF isInstanceOf(Class<?> expected) {
        if (!ClassUtils.wrap(expected).isInstance(this.actual)) {
            this.setDefaultDescription("It is expected to be instance of the type, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public SELF predicate(Predicate<ACTUAL> predicate) {
        if (!Objects.requireNonNull(predicate, "Predicate is not allowed to be null").test(this.actual)) {
            this.setDefaultDescription("It is expected to be true, but it isn't. (expected: 'false')", new Object[0]);
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public <T> SELF returns(T expected, Function<ACTUAL, T> from) {
        T actual = Objects.requireNonNull(from.apply(this.actual), "Function is not allowed to be null");
        if (!Objects.deepEquals(actual, expected)) {
            this.setDefaultDescription("They are expected to be equal, but they aren't. (expected: '{0}', actual: '{1}')", expected, actual);
            throw this.getException();
        }
        return (SELF)((ObjectAssert)this.self);
    }

    public ClassAssert<?, ACTUAL> asClass() {
        ClassAssert<?, ?> assertion = Asserts.that(this.actual.getClass());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public StringAssert<?> asString() {
        StringAssert<?> assertion = Asserts.that(this.actual.toString());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

