/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.lang;

import io.github.imsejin.common.assertion.lang.CharSequenceAssert;
import java.util.regex.Pattern;

public class StringAssert<SELF extends StringAssert<SELF>>
extends CharSequenceAssert<SELF, String> {
    public StringAssert(String actual) {
        super(actual);
    }

    public SELF hasText() {
        for (char c : ((String)this.actual).toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return (SELF)((StringAssert)this.self);
        }
        this.setDefaultDescription("It is expected to have text, but it isn't. (actual: '{0}')", this.actual);
        throw this.getException();
    }

    public SELF isNumeric() {
        if (((String)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to be numeric, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        for (char c : ((String)this.actual).toCharArray()) {
            if (Character.isDigit(c)) continue;
            this.setDefaultDescription("It is expected to be numeric, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF isLetter() {
        if (((String)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to be letter, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        for (char c : ((String)this.actual).toCharArray()) {
            if (Character.isLetter(c)) continue;
            this.setDefaultDescription("It is expected to be letter, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF isLetterOrDigit() {
        if (((String)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to be letter or digit, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        for (char c : ((String)this.actual).toCharArray()) {
            if (Character.isLetterOrDigit(c)) continue;
            this.setDefaultDescription("It is expected to be letter or digit, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF isUpperCase() {
        if (((String)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to have only uppercase letter(s), but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        for (char c : ((String)this.actual).toCharArray()) {
            if (Character.isUpperCase(c)) continue;
            this.setDefaultDescription("It is expected to have only uppercase letter(s), but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF isLowerCase() {
        if (((String)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to have only lowercase letter(s), but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        for (char c : ((String)this.actual).toCharArray()) {
            if (Character.isLowerCase(c)) continue;
            this.setDefaultDescription("It is expected to have only lowercase letter(s), but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF isAlphabetic() {
        if (((String)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to be alphabetic, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        for (char c : ((String)this.actual).toCharArray()) {
            if (Character.isAlphabetic(c)) continue;
            this.setDefaultDescription("It is expected to be alphabetic, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF startsWith(String expected) {
        if (expected == null || !((String)this.actual).startsWith(expected)) {
            this.setDefaultDescription("It is expected to start with the given string, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF endsWith(String expected) {
        if (expected == null || !((String)this.actual).endsWith(expected)) {
            this.setDefaultDescription("It is expected to end with the given string, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF contains(CharSequence expected) {
        if (expected == null || !((String)this.actual).contains(expected)) {
            this.setDefaultDescription("It is expected to contain the given string, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF matches(String expected) {
        if (!((String)this.actual).matches(expected)) {
            this.setDefaultDescription("It is expected to match the given regular expression, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }

    public SELF matches(Pattern expected) {
        if (!expected.matcher((CharSequence)this.actual).matches()) {
            this.setDefaultDescription("It is expected to match the given regular expression, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((StringAssert)this.self);
    }
}

