/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.math;

import io.github.imsejin.common.assertion.composition.DecimalNumberAssertable;
import io.github.imsejin.common.assertion.lang.NumberAssert;
import io.github.imsejin.common.util.NumberUtils;
import java.math.BigDecimal;

public class BigDecimalAssert<SELF extends BigDecimalAssert<SELF>>
extends NumberAssert<SELF, BigDecimal>
implements DecimalNumberAssertable<SELF, BigDecimal> {
    public BigDecimalAssert(BigDecimal actual) {
        super(actual);
    }

    @Override
    public SELF isEqualTo(BigDecimal expected) {
        if (((BigDecimal)this.actual).compareTo(expected) != 0) {
            this.setDefaultDescription("They are expected to be equal, but they aren't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((BigDecimalAssert)this.self);
    }

    @Override
    public SELF isNotEqualTo(BigDecimal expected) {
        if (((BigDecimal)this.actual).compareTo(expected) == 0) {
            this.setDefaultDescription("They are expected to be not equal, but they are. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((BigDecimalAssert)this.self);
    }

    @Override
    public SELF hasDecimalPart() {
        if (!NumberUtils.hasDecimalPart((BigDecimal)this.actual)) {
            this.setDefaultDescription("It is expected to have decimal part, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((BigDecimalAssert)this.self);
    }
}

