/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.OffsetAssertable;
import io.github.imsejin.common.assertion.time.InstantAssert;
import io.github.imsejin.common.assertion.time.LocalTimeAssert;
import io.github.imsejin.common.assertion.time.OffsetTimeAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoLocalDateAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoLocalDateTimeAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoZonedDateTimeAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class OffsetDateTimeAssert<SELF extends OffsetDateTimeAssert<SELF>>
extends AbstractTemporalAccessorAssert<SELF, OffsetDateTime>
implements OffsetAssertable<SELF, OffsetDateTime> {
    public OffsetDateTimeAssert(OffsetDateTime actual) {
        super(actual);
    }

    @Override
    public SELF isSameOffset(ZoneOffset expected) {
        ZoneOffset offset = ((OffsetDateTime)this.actual).getOffset();
        if (!offset.equals(expected)) {
            this.setDefaultDescription("They are expected to have the same offset, but they aren't. (expected: '{0}', actual: '{1}')", expected, offset);
            throw this.getException();
        }
        return (SELF)((OffsetDateTimeAssert)this.self);
    }

    @Override
    public SELF isNotSameOffset(ZoneOffset expected) {
        ZoneOffset offset = ((OffsetDateTime)this.actual).getOffset();
        if (offset.equals(expected)) {
            this.setDefaultDescription("They are expected not to have the same offset, but they are. (expected: '{0}', actual: '{1}')", expected, offset);
            throw this.getException();
        }
        return (SELF)((OffsetDateTimeAssert)this.self);
    }

    public ChronoLocalDateAssert<?> asLocalDate() {
        ChronoLocalDateAssert<?> assertion = Asserts.that(((OffsetDateTime)this.actual).toLocalDate());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public ChronoLocalDateTimeAssert<?, LocalDate> asLocalDateTime() {
        ChronoLocalDateTimeAssert<?, LocalDate> assertion = Asserts.that(((OffsetDateTime)this.actual).toLocalDateTime());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public ChronoZonedDateTimeAssert<?, LocalDate> asZonedDateTime() {
        ChronoZonedDateTimeAssert<?, LocalDate> assertion = Asserts.that(((OffsetDateTime)this.actual).toZonedDateTime());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public LocalTimeAssert<?> asLocalTime() {
        LocalTimeAssert<?> assertion = Asserts.that(((OffsetDateTime)this.actual).toLocalTime());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public OffsetTimeAssert<?> asOffsetTime() {
        OffsetTimeAssert<?> assertion = Asserts.that(((OffsetDateTime)this.actual).toOffsetTime());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public InstantAssert<?> asInstant() {
        InstantAssert<?> assertion = Asserts.that(((OffsetDateTime)this.actual).toInstant());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

