/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.OffsetAssertable;
import io.github.imsejin.common.assertion.time.LocalTimeAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import java.time.OffsetTime;
import java.time.ZoneOffset;

public class OffsetTimeAssert<SELF extends OffsetTimeAssert<SELF>>
extends AbstractTemporalAccessorAssert<SELF, OffsetTime>
implements OffsetAssertable<SELF, OffsetTime> {
    public OffsetTimeAssert(OffsetTime actual) {
        super(actual);
    }

    @Override
    public SELF isSameOffset(ZoneOffset expected) {
        ZoneOffset offset = ((OffsetTime)this.actual).getOffset();
        if (!offset.equals(expected)) {
            this.setDefaultDescription("They are expected to have the same offset, but they aren't. (expected: '{0}', actual: '{1}')", expected, offset);
            throw this.getException();
        }
        return (SELF)((OffsetTimeAssert)this.self);
    }

    @Override
    public SELF isNotSameOffset(ZoneOffset expected) {
        ZoneOffset offset = ((OffsetTime)this.actual).getOffset();
        if (offset.equals(expected)) {
            this.setDefaultDescription("They are expected not to have the same offset, but they are. (expected: '{0}', actual: '{1}')", expected, offset);
            throw this.getException();
        }
        return (SELF)((OffsetTimeAssert)this.self);
    }

    public LocalTimeAssert<?> asLocalTime() {
        LocalTimeAssert<?> assertion = Asserts.that(((OffsetTime)this.actual).toLocalTime());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

