/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.YearAssertable;
import io.github.imsejin.common.assertion.lang.NumberAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import java.time.Year;

public class YearAssert<SELF extends YearAssert<SELF>>
extends AbstractTemporalAccessorAssert<SELF, Year>
implements YearAssertable<SELF, Year> {
    public YearAssert(Year actual) {
        super(actual);
    }

    @Override
    public SELF isLeapYear() {
        if (!((Year)this.actual).isLeap()) {
            this.setDefaultDescription("It is expected to be leap year, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((YearAssert)this.self);
    }

    @Override
    public SELF isNotLeapYear() {
        if (((Year)this.actual).isLeap()) {
            this.setDefaultDescription("It is expected not to be leap year, but it is. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((YearAssert)this.self);
    }

    public NumberAssert<?, Integer> asValue() {
        NumberAssert<?, Integer> assertion = Asserts.that(((Year)this.actual).getValue());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public NumberAssert<?, Integer> asLength() {
        NumberAssert<?, Integer> assertion = Asserts.that(((Year)this.actual).length());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

