/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.YearAssertable;
import io.github.imsejin.common.assertion.time.MonthAssert;
import io.github.imsejin.common.assertion.time.YearAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import java.time.Month;
import java.time.Year;
import java.time.YearMonth;

public class YearMonthAssert<SELF extends YearMonthAssert<SELF>>
extends AbstractTemporalAccessorAssert<SELF, YearMonth>
implements YearAssertable<SELF, YearMonth> {
    public YearMonthAssert(YearMonth actual) {
        super(actual);
    }

    @Override
    public SELF isLeapYear() {
        if (!((YearMonth)this.actual).isLeapYear()) {
            this.setDefaultDescription("It is expected to be leap year, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((YearMonthAssert)this.self);
    }

    @Override
    public SELF isNotLeapYear() {
        if (((YearMonth)this.actual).isLeapYear()) {
            this.setDefaultDescription("It is expected not to be leap year, but it is. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((YearMonthAssert)this.self);
    }

    public YearAssert<?> asYear() {
        YearAssert<?> assertion = Asserts.that(Year.of(((YearMonth)this.actual).getYear()));
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public MonthAssert<?> asMonth() {
        MonthAssert<?> assertion = Asserts.that(Month.of(((YearMonth)this.actual).getMonthValue()));
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

