/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.time.chrono;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.time.InstantAssert;
import io.github.imsejin.common.assertion.time.LocalTimeAssert;
import io.github.imsejin.common.assertion.time.OffsetDateTimeAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoLocalDateAssert;
import io.github.imsejin.common.assertion.time.chrono.ChronoLocalDateTimeAssert;
import io.github.imsejin.common.assertion.time.temporal.AbstractTemporalAccessorAssert;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoZonedDateTime;

public class ChronoZonedDateTimeAssert<SELF extends ChronoZonedDateTimeAssert<SELF, DATE>, DATE extends ChronoLocalDate>
extends AbstractTemporalAccessorAssert<SELF, ChronoZonedDateTime<?>> {
    public ChronoZonedDateTimeAssert(ChronoZonedDateTime<DATE> actual) {
        super(actual);
    }

    public SELF isSameZone(ZoneId expected) {
        ZoneId zone = ((ChronoZonedDateTime)this.actual).getZone();
        if (!zone.equals(expected)) {
            this.setDefaultDescription("They are expected to have the same zone, but they aren't. (expected: '{0}', actual: '{1}')", expected, zone);
            throw this.getException();
        }
        return (SELF)((ChronoZonedDateTimeAssert)this.self);
    }

    public SELF isNotSameZone(ZoneId expected) {
        ZoneId zone = ((ChronoZonedDateTime)this.actual).getZone();
        if (zone.equals(expected)) {
            this.setDefaultDescription("They are expected not to have the same zone, but they are. (expected: '{0}', actual: '{1}')", expected, zone);
            throw this.getException();
        }
        return (SELF)((ChronoZonedDateTimeAssert)this.self);
    }

    public ChronoLocalDateAssert<?> asLocalDate() {
        ChronoLocalDateAssert<?> assertion = Asserts.that(((ChronoZonedDateTime)this.actual).toLocalDate());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public ChronoLocalDateTimeAssert<?, DATE> asLocalDateTime() {
        ChronoLocalDateTimeAssert assertion = Asserts.that(((ChronoZonedDateTime)this.actual).toLocalDateTime());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public LocalTimeAssert<?> asLocalTime() {
        LocalTimeAssert<?> assertion = Asserts.that(((ChronoZonedDateTime)this.actual).toLocalTime());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public OffsetDateTimeAssert<?> asOffsetDateTime() {
        LocalDateTime dateTime = LocalDateTime.ofInstant(((ChronoZonedDateTime)this.actual).toInstant(), ((ChronoZonedDateTime)this.actual).getZone());
        ZoneOffset offset = ((ChronoZonedDateTime)this.actual).getOffset();
        OffsetDateTimeAssert<?> assertion = Asserts.that(OffsetDateTime.of(dateTime, offset));
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public InstantAssert<?> asInstant() {
        InstantAssert<?> assertion = Asserts.that(((ChronoZonedDateTime)this.actual).toInstant());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

