/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.composition.IterationAssertable;
import io.github.imsejin.common.assertion.lang.ArrayAssert;
import io.github.imsejin.common.assertion.lang.NumberAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.util.ArrayUtils;
import io.github.imsejin.common.util.CollectionUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;

public class CollectionAssert<SELF extends CollectionAssert<SELF, ACTUAL, ELEMENT>, ACTUAL extends Collection<? extends ELEMENT>, ELEMENT>
extends ObjectAssert<SELF, ACTUAL>
implements IterationAssertable<SELF, ACTUAL, ELEMENT> {
    public CollectionAssert(ACTUAL target) {
        super(target);
    }

    @Override
    public SELF isEmpty() {
        if (!((Collection)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to be empty, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF hasElement() {
        if (((Collection)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to have element, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    public SELF hasSizeOf(int expected) {
        if (((Collection)this.actual).size() != expected) {
            this.setDefaultDescription("It is expected to be the same size, but it isn't. (expected: '{0}', actual: '{1}')", expected, ((Collection)this.actual).size());
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    public SELF isSameSize(Collection<?> expected) {
        if (expected == null || ((Collection)this.actual).size() != expected.size()) {
            this.setDefaultDescription("They are expected to be the same size, but they aren't. (expected: '{0}', actual: '{1}')", expected == null ? "null" : Integer.valueOf(expected.size()), ((Collection)this.actual).size());
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    public SELF isNotSameSize(Collection<?> expected) {
        if (expected == null || ((Collection)this.actual).size() == expected.size()) {
            this.setDefaultDescription("They are expected to be not the same size, but they are. (expected: '{0}', actual: '{1}')", expected == null ? "null" : Integer.valueOf(expected.size()), ((Collection)this.actual).size());
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF contains(ELEMENT expected) {
        for (Object element : (Collection)this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            return (SELF)((CollectionAssert)this.self);
        }
        this.setDefaultDescription("It is expected to contain the given element, but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
        throw this.getException();
    }

    @Override
    public SELF doesNotContain(ELEMENT expected) {
        for (Object element : (Collection)this.actual) {
            if (!Objects.deepEquals(element, expected)) continue;
            this.setDefaultDescription("It is expected not to contain the given element, but it is. (expected: '{0}', actual: '{1}', unexpected: '{2}')", expected, this.actual, element);
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF containsNull() {
        for (Object element : (Collection)this.actual) {
            if (element != null) continue;
            return (SELF)((CollectionAssert)this.self);
        }
        this.setDefaultDescription("It is expected to contain null, but it isn't. (actual: '{0}')", this.actual);
        throw this.getException();
    }

    @Override
    public SELF doesNotContainNull() {
        for (Object element : (Collection)this.actual) {
            if (element != null) continue;
            this.setDefaultDescription("It is expected not to contain null, but it is. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF containsAny(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((CollectionAssert)this.self);
        }
        for (ELEMENT item : expected) {
            for (Object element : (Collection)this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                return (SELF)((CollectionAssert)this.self);
            }
        }
        this.setDefaultDescription("It is expected to contain at least one of the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
        throw this.getException();
    }

    @Override
    public SELF containsAll(ACTUAL expected) {
        if (CollectionUtils.isNullOrEmpty(expected)) {
            return (SELF)((CollectionAssert)this.self);
        }
        block0: for (Object item : expected) {
            for (Object element : (Collection)this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                continue block0;
            }
            this.setDefaultDescription("It is expected to contain all the given elements, but it isn't. (expected: '{0}', actual: '{1}', missing: '{2}')", expected, this.actual, item);
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF doesNotContainAll(ACTUAL expected) {
        if (((Collection)this.actual).isEmpty() || CollectionUtils.isNullOrEmpty(expected)) {
            return (SELF)((CollectionAssert)this.self);
        }
        for (Object item : expected) {
            for (Object element : (Collection)this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                this.setDefaultDescription("It is expected not to contain all the given elements, but it is. (expected: '{0}', actual: '{1}')", expected, this.actual);
                throw this.getException();
            }
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF containsOnly(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((CollectionAssert)this.self);
        }
        block0: for (ELEMENT item : expected) {
            for (Object element : (Collection)this.actual) {
                if (!Objects.deepEquals(element, item)) continue;
                continue block0;
            }
            this.setDefaultDescription("It is expected to contain only the given element(s), but it doesn't contain some element(s). (expected: '{0}', actual: '{1}', missing: '{2}')", expected, this.actual, item);
            throw this.getException();
        }
        block2: for (Object element : (Collection)this.actual) {
            for (ELEMENT item : expected) {
                if (Objects.deepEquals(element, item)) continue block2;
            }
            this.setDefaultDescription("It is expected to contain only the given element(s), but it contains unexpected element(s). (expected: '{0}', actual: '{1}', unexpected: '{2}')", expected, this.actual, element);
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF containsOnlyNulls() {
        if (((Collection)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to contain only null elements, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        for (Object element : (Collection)this.actual) {
            if (element == null) continue;
            this.setDefaultDescription("It is expected to contain only null elements, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF doesNotHaveDuplicates() {
        if (((Collection)this.actual).isEmpty() || ((Collection)this.actual).size() == 1) {
            return (SELF)((CollectionAssert)this.self);
        }
        TreeSet noDuplicates = new TreeSet((o1, o2) -> {
            if (Objects.deepEquals(o1, o2)) {
                return 0;
            }
            return ArrayUtils.hashCode(o1) < ArrayUtils.hashCode(o2) ? -1 : 1;
        });
        for (Object element : (Collection)this.actual) {
            if (noDuplicates.contains(element)) {
                this.setDefaultDescription("It is expected not to have duplicated elements, but it is. (actual: '{0}', duplicated: '{1}')", this.actual, element);
                throw this.getException();
            }
            noDuplicates.add(element);
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF anyMatch(Predicate<ELEMENT> expected) {
        for (Object element : (Collection)this.actual) {
            if (!expected.test(element)) continue;
            return (SELF)((CollectionAssert)this.self);
        }
        this.setDefaultDescription("It is expected to match the given condition with its any elements, but it isn't. (actual: '{0}')", this.actual);
        throw this.getException();
    }

    @Override
    public SELF allMatch(Predicate<ELEMENT> expected) {
        if (((Collection)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to match the given condition with its all elements, but it isn't. (actual: '{0}', unexpected: '{1}')", this.actual, "");
            throw this.getException();
        }
        for (Object element : (Collection)this.actual) {
            if (expected.test(element)) continue;
            this.setDefaultDescription("It is expected to match the given condition with its all elements, but it isn't. (actual: '{0}', unexpected: '{1}')", this.actual, element);
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    @Override
    public SELF noneMatch(Predicate<ELEMENT> expected) {
        for (Object element : (Collection)this.actual) {
            if (!expected.test(element)) continue;
            this.setDefaultDescription("It is expected not to match the given condition with its all elements, but it is. (actual: '{0}', unexpected: '{1}')", this.actual, element);
            throw this.getException();
        }
        return (SELF)((CollectionAssert)this.self);
    }

    public ArrayAssert<?, ELEMENT> asArray() {
        ArrayAssert<?, Object> assertion = Asserts.that(((Collection)this.actual).toArray());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public NumberAssert<?, Integer> asSize() {
        NumberAssert<?, Integer> assertion = Asserts.that(((Collection)this.actual).size());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

