/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util;

import io.github.imsejin.common.assertion.composition.RandomAccessIterationAssertable;
import io.github.imsejin.common.assertion.util.CollectionAssert;
import io.github.imsejin.common.util.ArrayUtils;
import java.util.List;
import java.util.Objects;

public class ListAssert<SELF extends ListAssert<SELF, ACTUAL, ELEMENT>, ACTUAL extends List<? extends ELEMENT>, ELEMENT>
extends CollectionAssert<SELF, ACTUAL, ELEMENT>
implements RandomAccessIterationAssertable<SELF, ACTUAL, ELEMENT> {
    public ListAssert(ACTUAL target) {
        super(target);
    }

    @Override
    @SafeVarargs
    public final SELF startsWith(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ListAssert)this.self);
        }
        if (((List)this.actual).size() < expected.length) {
            this.setDefaultDescription("It is expected to start with the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        for (int i = 0; i < expected.length; ++i) {
            ELEMENT item;
            Object element = ((List)this.actual).get(i);
            if (Objects.deepEquals(element, item = expected[i])) continue;
            this.setDefaultDescription("It is expected to start with the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return (SELF)((ListAssert)this.self);
    }

    @Override
    @SafeVarargs
    public final SELF endsWith(ELEMENT ... expected) {
        if (ArrayUtils.isNullOrEmpty(expected)) {
            return (SELF)((ListAssert)this.self);
        }
        if (((List)this.actual).size() < expected.length) {
            this.setDefaultDescription("It is expected to end with the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        for (int i = 0; i < expected.length; ++i) {
            ELEMENT item;
            Object element = ((List)this.actual).get(((List)this.actual).size() - expected.length + i);
            if (Objects.deepEquals(element, item = expected[i])) continue;
            this.setDefaultDescription("It is expected to end with the given element(s), but it isn't. (expected: '{0}', actual: '{1}')", expected, this.actual);
            throw this.getException();
        }
        return null;
    }
}

