/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.assertion.util;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.NumberAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.util.CollectionAssert;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MapAssert<SELF extends MapAssert<SELF, ACTUAL, K, V>, ACTUAL extends Map<K, V>, K, V>
extends ObjectAssert<SELF, ACTUAL> {
    public MapAssert(ACTUAL actual) {
        super(actual);
    }

    public SELF isEmpty() {
        if (!((Map)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to be empty, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF hasEntry() {
        if (((Map)this.actual).isEmpty()) {
            this.setDefaultDescription("It is expected to have entry, but it isn't. (actual: '{0}')", this.actual);
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF hasSizeOf(int expected) {
        if (((Map)this.actual).size() != expected) {
            this.setDefaultDescription("It is expected to be the same size, but it isn't. (expected: '{0}', actual: '{1}')", expected, ((Map)this.actual).size());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF isSameSize(Map<?, ?> expected) {
        if (expected == null || ((Map)this.actual).size() != expected.size()) {
            this.setDefaultDescription("They are expected to be the same size, but they aren't. (expected: '{0}', actual: '{1}')", expected == null ? "null" : Integer.valueOf(expected.size()), ((Map)this.actual).size());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF isNotSameSize(Map<?, ?> expected) {
        if (expected == null || ((Map)this.actual).size() == expected.size()) {
            this.setDefaultDescription("They are expected to be not the same size, but they are. (expected: '{0}', actual: '{1}')", expected == null ? "null" : Integer.valueOf(expected.size()), ((Map)this.actual).size());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF containsKey(K expected) {
        if (!((Map)this.actual).containsKey(expected)) {
            this.setDefaultDescription("It is expected to contain the given key, but it doesn't. (expected: '{0}', actual: '{1}')", expected, ((Map)this.actual).keySet());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF containsValue(V expected) {
        if (!((Map)this.actual).containsValue(expected)) {
            this.setDefaultDescription("It is expected to contain the given value, but it doesn't. (expected: '{0}', actual: '{1}')", expected, ((Map)this.actual).values());
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF containsAllKeys(Map<? extends K, ?> expected) {
        return this.containsAllKeys(expected.keySet());
    }

    public SELF containsAllKeys(Collection<? extends K> expected) {
        Set actualKeys = ((Map)this.actual).keySet();
        if (!actualKeys.containsAll(expected)) {
            this.setDefaultDescription("It is expected to contain all the given keys, but it doesn't. (expected: '{0}', actual: '{1}')", expected, actualKeys);
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public SELF containsAllValues(Map<?, ? extends V> expected) {
        return this.containsAllValues(expected.values());
    }

    public SELF containsAllValues(Collection<? extends V> expected) {
        Collection actualValues = ((Map)this.actual).values();
        if (!actualValues.containsAll(expected)) {
            this.setDefaultDescription("It is expected to contain all the given values, but it doesn't. (expected: '{0}', actual: '{1}')", expected, actualValues);
            throw this.getException();
        }
        return (SELF)((MapAssert)this.self);
    }

    public CollectionAssert<?, Collection<K>, K> asKeySet() {
        CollectionAssert assertion = Asserts.that(((Map)this.actual).keySet());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public CollectionAssert<?, Collection<V>, V> asValues() {
        CollectionAssert assertion = Asserts.that(((Map)this.actual).values());
        Descriptor.merge(this, assertion);
        return assertion;
    }

    public NumberAssert<?, Integer> asSize() {
        NumberAssert<?, Integer> assertion = Asserts.that(((Map)this.actual).size());
        Descriptor.merge(this, assertion);
        return assertion;
    }
}

