/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.model.graph.traverse;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.model.graph.Graph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;

public class DepthFirstIterator<E>
implements Iterator<E> {
    private final Set<E> visited = new HashSet();
    private final Graph<E> graph;
    private final Stack<Iterator<E>> stack = new Stack();
    private E next;

    public DepthFirstIterator(Graph<E> graph, E root) {
        ((ObjectAssert)Asserts.that(graph).as("DepthFirstIterator.graph is not allowed to be null", new Object[0])).isNotNull();
        ((ObjectAssert)((Descriptor)((ObjectAssert)Asserts.that(root).as("DepthFirstIterator.root is not allowed to be null", new Object[0])).isNotNull()).as("DepthFirstIterator.root must be in graph as a vertex: '{0}'", root)).predicate(graph::containsVertex);
        this.graph = graph;
        this.stack.push(graph.getAdjacentVertices(root).iterator());
        this.next = root;
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("DepthFirstIterator has no more elements");
        }
        try {
            this.visited.add(this.next);
            E e = this.next;
            return e;
        }
        finally {
            this.advance();
        }
    }

    private void advance() {
        Iterator<E> neighbors = this.stack.peek();
        while (true) {
            if (!neighbors.hasNext()) {
                this.stack.pop();
                if (!this.hasNext()) {
                    this.next = null;
                    return;
                }
                neighbors = this.stack.peek();
                continue;
            }
            this.next = neighbors.next();
            if (!this.visited.contains(this.next)) break;
        }
        this.stack.push(this.graph.getAdjacentVertices(this.next).iterator());
    }

    public static <E> void traverse(Graph<E> graph, E root, Consumer<E> consumer) {
        ((ObjectAssert)Asserts.that(graph).as("DepthFirstIterator.graph is not allowed to be null", new Object[0])).isNotNull();
        ((ObjectAssert)((Descriptor)((ObjectAssert)Asserts.that(root).as("DepthFirstIterator.root is not allowed to be null", new Object[0])).isNotNull()).as("DepthFirstIterator.root must be in graph as a vertex: '{0}'", root)).predicate(graph::containsVertex);
        LinkedHashSet visited = new LinkedHashSet();
        Stack<E> stack = new Stack<E>();
        stack.push(root);
        while (!stack.isEmpty()) {
            Object vertex = stack.pop();
            if (visited.contains(vertex)) continue;
            consumer.accept(vertex);
            visited.add(vertex);
            for (E v : graph.getAdjacentVertices(vertex)) {
                stack.push(v);
            }
        }
    }
}

