/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.security.crypto.aes;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.lang.CharSequenceAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import io.github.imsejin.common.security.crypto.Crypto;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

abstract class AES
implements Crypto {
    private static final String ALGORITHM = "AES";
    private final Key key;
    private final Charset charset;

    protected AES(String key, int length, Charset charset) {
        ((CharSequenceAssert)((StringAssert)((StringAssert)Asserts.that(key).as("{0}.key must have {1} characters, but it isn't: '{2}'", this.getClass().getSimpleName(), length, key)).isNotNull()).hasText()).hasLengthOf(length);
        ((ObjectAssert)Asserts.that(charset).as("{0}.charset is not allowed to be null, but it is", this.getClass().getSimpleName(), charset)).isNotNull();
        byte[] bytes = key.getBytes(charset);
        this.key = new SecretKeySpec(bytes, ALGORITHM);
        this.charset = charset;
    }

    @Override
    public String encrypt(String text) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, this.key);
            byte[] encrypted = cipher.doFinal(text.getBytes(this.charset));
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decrypt(String cipherText) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, this.key);
            byte[] decodedBytes = Base64.getDecoder().decode(cipherText);
            byte[] decrypted = cipher.doFinal(decodedBytes);
            return new String(decrypted, this.charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getKey() {
        return new String(this.key.getEncoded(), this.charset);
    }
}

