/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.security.crypto.rsa;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.lang.NumberAssert;
import io.github.imsejin.common.security.crypto.Crypto;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class RSA
implements Crypto {
    private static final String ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_SIZE = 2048;
    private static final KeyFactory keyFactory;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public RSA() {
        KeyPair keyPair = RSA.generateKeyPair(2048);
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
    }

    public RSA(String publicKey, String privateKey) {
        this.publicKey = RSA.getPublicKeyFrom(publicKey);
        this.privateKey = RSA.getPrivateKeyFrom(privateKey);
    }

    public static KeyPair generateKeyPair(int keySize) {
        ((NumberAssert)Asserts.that(keySize).as("KeyPair.keySize allows 512 ~ 65536, but it isn't: {0}", keySize)).isBetween(512, 65536);
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(ALGORITHM);
            generator.initialize(keySize, new SecureRandom());
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static PublicKey getPublicKeyFrom(String s) {
        byte[] bytes = Base64.getDecoder().decode(s);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        try {
            return keyFactory.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static PrivateKey getPrivateKeyFrom(String s) {
        byte[] bytes = Base64.getDecoder().decode(s);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            return keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String encrypt(String text) {
        return this.encryptWithPrivateKey(text);
    }

    public String encryptWithPublicKey(String text) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, this.publicKey);
            byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
            byte[] encrypted = cipher.doFinal(bytes);
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public String encryptWithPrivateKey(String text) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, this.privateKey);
            byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
            byte[] encrypted = cipher.doFinal(bytes);
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String decrypt(String cipherText) {
        return this.decryptWithPublicKey(cipherText);
    }

    public String decryptWithPublicKey(String cipherText) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, this.publicKey);
            byte[] bytes = cipherText.getBytes(StandardCharsets.UTF_8);
            byte[] decoded = Base64.getDecoder().decode(bytes);
            byte[] decrypted = cipher.doFinal(decoded);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public String decryptWithPrivateKey(String cipherText) {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, this.privateKey);
            byte[] bytes = cipherText.getBytes(StandardCharsets.UTF_8);
            byte[] decoded = Base64.getDecoder().decode(bytes);
            byte[] decrypted = cipher.doFinal(decoded);
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getKey() {
        return this.getPublicKey();
    }

    public String getPublicKey() {
        return Base64.getEncoder().encodeToString(this.publicKey.getEncoded());
    }

    public String getPrivateKey() {
        return Base64.getEncoder().encodeToString(this.privateKey.getEncoded());
    }

    static {
        try {
            keyFactory = KeyFactory.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

