/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.security.model;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.Descriptor;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;

public class Verification {
    private final Object credentials;
    private final Duration duration;
    private final LocalDateTime createdDateTime = LocalDateTime.now();

    public Verification(Object credentials, Duration duration) {
        ((ObjectAssert)Asserts.that(credentials).as("Verification.credentials is allowed to be null", new Object[0])).isNotNull();
        ((ObjectAssert)((Descriptor)((ObjectAssert)Asserts.that(duration).as("Verification.duration is allowed to be null", new Object[0])).isNotNull()).as("Verification.duration must be zero or positive, but it is not: '{0}'", duration)).returns(false, Duration::isNegative);
        this.credentials = credentials;
        this.duration = duration;
    }

    public boolean verify(Object credentials) {
        if (!Objects.equals(this.credentials, credentials)) {
            return false;
        }
        return !this.isExpired();
    }

    public boolean isExpired() {
        Duration duration = Duration.between(this.createdDateTime, LocalDateTime.now());
        return duration.isNegative() || duration.getSeconds() > this.duration.getSeconds();
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public LocalDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }
}

