/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.tool;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.util.ClassUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ClassFinder {
    @ExcludeFromGeneratedJacocoReport
    private ClassFinder() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static Set<Class<?>> getAllSubtypes(Class<?> superclass) {
        return ClassFinder.getAllSubtypes(superclass, SearchPolicy.ALL, Thread.currentThread().getContextClassLoader());
    }

    public static Set<Class<?>> getAllSubtypes(Class<?> superclass, SearchPolicy searchPolicy) {
        return ClassFinder.getAllSubtypes(superclass, searchPolicy, Thread.currentThread().getContextClassLoader());
    }

    public static Set<Class<?>> getAllSubtypes(Class<?> superclass, SearchPolicy searchPolicy, ClassLoader classLoader) {
        Pattern pattern = Pattern.compile("^[a-zA-Z].+\\$\\d+.*$");
        ArrayList subclasses = new ArrayList();
        ClassFinder.findClasses(name -> {
            try {
                if (pattern.matcher((CharSequence)name).matches()) {
                    return true;
                }
                return subclasses.add(Class.forName(name, false, classLoader));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        return subclasses.stream().filter(clazz -> searchPolicy.search(superclass, (Class<?>)clazz)).collect(Collectors.toSet());
    }

    public static void findClasses(Predicate<String> visitor) {
        String[] paths;
        File file = new File(System.getProperty("java.home"), "lib");
        if (file.exists()) {
            ClassFinder.findClasses0(file, file, true, visitor);
        }
        String classpath = System.getProperty("java.class.path");
        for (String path : paths = classpath.split(File.pathSeparator)) {
            file = new File(path);
            if (!file.exists()) continue;
            ClassFinder.findClasses0(file, file, false, visitor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean findClasses0(File root, File file, boolean includeJars, Predicate<String> visitor) {
        if (file.isDirectory()) {
            for (File child : Objects.requireNonNull(file.listFiles())) {
                if (ClassFinder.findClasses0(root, child, includeJars, visitor)) continue;
                return false;
            }
        }
        String filename = file.getName().toLowerCase();
        if (includeJars && filename.endsWith(".jar")) {
            try (JarFile jar = new JarFile(file);){
                JarEntry entry;
                String name;
                int extIndex;
                Enumeration<JarEntry> entries = jar.entries();
                do {
                    if (!entries.hasMoreElements()) return true;
                } while ((extIndex = (name = (entry = entries.nextElement()).getName()).lastIndexOf(".class")) <= 0 || visitor.test(name.substring(0, extIndex).replace('/', '.')));
                boolean bl = false;
                return bl;
            }
            catch (IOException ignored) {
                return true;
            }
        }
        if (!filename.endsWith(".class")) return true;
        return visitor.test(ClassFinder.createClassName(root, file));
    }

    private static String createClassName(File root, File file) {
        StringBuilder sb = new StringBuilder();
        String fileName = file.getName();
        sb.append(fileName, 0, fileName.lastIndexOf(".class"));
        for (file = file.getParentFile(); file != null && !file.equals(root); file = file.getParentFile()) {
            sb.insert(0, '.').insert(0, file.getName());
        }
        return sb.toString();
    }

    public static enum SearchPolicy {
        CLASS{

            @Override
            public boolean search(Class<?> superclass, @Nullable Class<?> subclass) {
                return ClassUtils.isSuperclass(superclass, subclass);
            }
        }
        ,
        ALL{

            @Override
            public boolean search(Class<?> superclass, @Nullable Class<?> subclass) {
                Asserts.that(superclass).isNotNull();
                if (subclass == null || superclass == subclass) {
                    return false;
                }
                return superclass.isAssignableFrom(subclass);
            }
        };


        public abstract boolean search(Class<?> var1, @Nullable Class<?> var2);
    }
}

