/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.tool;

import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.lang.BooleanAssert;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import io.github.imsejin.common.tool.Tasks;
import io.github.imsejin.common.util.MathUtils;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;

public final class Stopwatch {
    static final int DECIMAL_PLACE = 6;
    private final Tasks tasks = new Tasks(this);
    private long startNanoTime;
    private long totalNanoTime;
    private String currentTaskName;
    private TimeUnit timeUnit;

    public Stopwatch() {
        this.timeUnit = TimeUnit.NANOSECONDS;
    }

    public Stopwatch(TimeUnit timeUnit) {
        ((ObjectAssert)Asserts.that(timeUnit).as("Stopwatch.timeUnit cannot be null", new Object[0])).isNotNull();
        this.timeUnit = timeUnit;
    }

    static double convertTimeUnit(double amount, TimeUnit from, TimeUnit to) {
        return from.ordinal() < to.ordinal() ? amount / (double)from.convert(1L, to) : amount * (double)to.convert(1L, from);
    }

    static String getTimeUnitAbbreviation(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "sec";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "hrs";
            }
            case DAYS: {
                return "days";
            }
        }
        throw new IllegalArgumentException("No TimeUnit equivalent for " + (Object)((Object)timeUnit));
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        ((ObjectAssert)Asserts.that(timeUnit).as("Stopwatch.timeUnit cannot be null", new Object[0])).isNotNull();
        this.timeUnit = timeUnit;
    }

    public void start() {
        this.start("");
    }

    public void start(String taskName) {
        ((StringAssert)Asserts.that(taskName).as("Task name cannot be null", new Object[0])).isNotNull();
        ((BooleanAssert)((BooleanAssert)Asserts.that(this.isRunning()).as("Stopwatch cannot start, when it is already running", new Object[0])).exception(UnsupportedOperationException::new)).isFalse();
        this.currentTaskName = taskName;
        this.startNanoTime = System.nanoTime();
    }

    public void start(String format, Object ... args) {
        ((StringAssert)Asserts.that(format).as("Task name cannot be null", new Object[0])).isNotNull();
        ((BooleanAssert)((BooleanAssert)Asserts.that(this.isRunning()).as("Stopwatch cannot start, when it is already running", new Object[0])).exception(UnsupportedOperationException::new)).isFalse();
        this.currentTaskName = String.format(format, args);
        this.startNanoTime = System.nanoTime();
    }

    public void stop() {
        ((BooleanAssert)((BooleanAssert)Asserts.that(this.isRunning()).as("Stopwatch cannot stop, when it is not running", new Object[0])).exception(UnsupportedOperationException::new)).isTrue();
        long elapsedNanoTime = System.nanoTime() - this.startNanoTime;
        this.totalNanoTime += elapsedNanoTime;
        this.tasks.add(elapsedNanoTime, this.currentTaskName);
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.currentTaskName != null;
    }

    public boolean hasNeverBeenStopped() {
        return this.tasks.isEmpty();
    }

    public void clear() {
        ((BooleanAssert)((BooleanAssert)Asserts.that(this.isRunning()).as("Stopwatch is running. To clear, stop it first", new Object[0])).exception(UnsupportedOperationException::new)).isFalse();
        this.forceClear();
    }

    public void forceClear() {
        this.tasks.clear();
        this.startNanoTime = 0L;
        this.totalNanoTime = 0L;
        this.currentTaskName = null;
    }

    public double getTotalTime() {
        ((BooleanAssert)((BooleanAssert)Asserts.that(this.hasNeverBeenStopped()).as("Stopwatch has no total time, because it has never been stopped", new Object[0])).exception(UnsupportedOperationException::new)).isFalse();
        return Stopwatch.convertTimeUnit(this.totalNanoTime, TimeUnit.NANOSECONDS, this.timeUnit);
    }

    public String getSummary() {
        double totalTime = MathUtils.floor(this.getTotalTime(), 6);
        String runningTime = BigDecimal.valueOf(totalTime).stripTrailingZeros().toPlainString();
        return "Stopwatch: RUNNING_TIME = " + runningTime + ' ' + Stopwatch.getTimeUnitAbbreviation(this.timeUnit);
    }

    public String getStatistics() {
        return this.getSummary() + this.tasks;
    }
}

