/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.tool;

import io.github.imsejin.common.tool.Stopwatch;
import io.github.imsejin.common.util.MathUtils;
import io.github.imsejin.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class Tasks {
    private final Stopwatch stopwatch;
    private final List<Task> list = new ArrayList<Task>();

    Tasks(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
    }

    public boolean add(long totalNanoTime, String name) {
        return this.list.add(new Task(totalNanoTime, name));
    }

    public void clear() {
        this.list.clear();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        double totalTime = MathUtils.floor(this.stopwatch.getTotalTime(), 6);
        TimeUnit timeUnit = this.stopwatch.getTimeUnit();
        for (Task task2 : this.list) {
            double taskTime = Stopwatch.convertTimeUnit(task2.getTotalNanoTime(), TimeUnit.NANOSECONDS, timeUnit);
            task2.setTaskTime(taskTime);
            task2.setTotalTime(taskTime, timeUnit);
            int percentage = (int)Math.round(taskTime / totalTime * 100.0);
            task2.setPercentage(percentage);
        }
        int timeUnitIndex = this.list.stream().map(task -> task.getTotalTime().length()).reduce(0, Math::max);
        String timeUnitColumn = String.format("%-" + timeUnitIndex + "s", Stopwatch.getTimeUnitAbbreviation(timeUnit));
        for (Task task3 : this.list) {
            task3.setTotalTime(task3.getTaskTime(), timeUnit, timeUnitIndex);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n----------------------------------------\n");
        sb.append(timeUnitColumn).append("  ").append(String.format("%-3c", Character.valueOf('%'))).append("  ").append("TASK_NAME");
        sb.append("\n----------------------------------------\n");
        for (Task task4 : this.list) {
            sb.append(task4).append('\n');
        }
        return sb.toString();
    }

    private static final class Task {
        private final long totalNanoTime;
        private final String name;
        private double taskTime;
        private String totalTime;
        private String percentage;

        private Task(long totalNanoTime, String name) {
            this.totalNanoTime = totalNanoTime;
            this.name = name;
        }

        public long getTotalNanoTime() {
            return this.totalNanoTime;
        }

        public double getTaskTime() {
            return this.taskTime;
        }

        public void setTaskTime(double taskTime) {
            this.taskTime = taskTime;
        }

        public String getTotalTime() {
            return this.totalTime;
        }

        public void setTotalTime(double totalTime, TimeUnit timeUnit) {
            String format = timeUnit == TimeUnit.NANOSECONDS ? "%.0f" : "%.6f";
            this.totalTime = String.format(format, totalTime);
        }

        public void setTotalTime(double totalTime, TimeUnit timeUnit, int len) {
            String format = timeUnit == TimeUnit.NANOSECONDS ? "%.0f" : "%.6f";
            this.totalTime = StringUtils.padEnd(len, String.format(format, totalTime));
        }

        public void setPercentage(int percentage) {
            this.percentage = String.format("%03d", percentage);
        }

        public String toString() {
            return this.totalTime + "  " + this.percentage + "  " + this.name;
        }
    }
}

