/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.model.graph.DirectedGraph;
import io.github.imsejin.common.model.graph.Graph;
import io.github.imsejin.common.util.ArrayUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public final class ClassUtils {
    @ExcludeFromGeneratedJacocoReport
    private ClassUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static boolean isEnumOrEnumConstant(@Nullable Class<?> clazz) {
        return clazz != null && Enum.class.isAssignableFrom(clazz);
    }

    public static boolean isAbstractClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        int modifiers = clazz.getModifiers();
        return Modifier.isAbstract(modifiers) && !Modifier.isFinal(modifiers) && !clazz.isArray() && !clazz.isPrimitive() && !clazz.isInterface() && !ClassUtils.isEnumOrEnumConstant(clazz);
    }

    public static boolean isSuperclass(Class<?> superclass, @Nullable Class<?> subclass) {
        if (subclass == null || superclass == subclass) {
            return false;
        }
        for (Class<?> c = subclass.getSuperclass(); c != null; c = c.getSuperclass()) {
            if (c != superclass) continue;
            return true;
        }
        return false;
    }

    public static boolean isWrapper(@Nullable Class<?> type) {
        return ClassUtils.isNumericWrapper(type) || type == Boolean.class || type == Character.class || type == Void.class;
    }

    public static boolean isNumeric(@Nullable Class<?> type) {
        return ClassUtils.isNumericPrimitive(type) || ClassUtils.isNumericWrapper(type);
    }

    public static boolean isNumericPrimitive(@Nullable Class<?> type) {
        return type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE;
    }

    public static boolean isNumericWrapper(@Nullable Class<?> type) {
        return type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class;
    }

    @Nullable
    public static Object initialValueOf(@Nullable Class<?> type) {
        if (ClassUtils.isNumericPrimitive(type)) {
            return 0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    @Nullable
    public static <T> Class<T> wrap(@Nullable Class<T> type) {
        if (type == null) {
            return null;
        }
        Class<Object> clazz = type;
        if (clazz == Void.TYPE) {
            clazz = Void.class;
        }
        if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        }
        if (clazz == Short.TYPE) {
            clazz = Short.class;
        }
        if (clazz == Character.TYPE) {
            clazz = Character.class;
        }
        if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        }
        if (clazz == Long.TYPE) {
            clazz = Long.class;
        }
        if (clazz == Float.TYPE) {
            clazz = Float.class;
        }
        if (clazz == Double.TYPE) {
            clazz = Double.class;
        }
        if (clazz.isArray()) {
            Class<?> actualType = ArrayUtils.resolveActualComponentType(clazz);
            if (!actualType.isPrimitive()) {
                return type;
            }
            int dimension = ArrayUtils.dimensionOf(clazz);
            return ArrayUtils.resolveArrayType(ClassUtils.wrap(actualType), dimension);
        }
        return clazz;
    }

    @Nullable
    public static <T> Class<T> unwrap(@Nullable Class<T> type) {
        if (type == null) {
            return null;
        }
        Class<Object> clazz = type;
        if (clazz == Void.class) {
            clazz = Void.TYPE;
        }
        if (clazz == Boolean.class) {
            clazz = Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            clazz = Byte.TYPE;
        }
        if (clazz == Short.class) {
            clazz = Short.TYPE;
        }
        if (clazz == Character.class) {
            clazz = Character.TYPE;
        }
        if (clazz == Integer.class) {
            clazz = Integer.TYPE;
        }
        if (clazz == Long.class) {
            clazz = Long.TYPE;
        }
        if (clazz == Float.class) {
            clazz = Float.TYPE;
        }
        if (clazz == Double.class) {
            clazz = Double.TYPE;
        }
        if (clazz.isArray()) {
            Class<?> actualType = ArrayUtils.resolveActualComponentType(clazz);
            if (actualType.isPrimitive()) {
                return type;
            }
            int dimension = ArrayUtils.dimensionOf(clazz);
            return ArrayUtils.resolveArrayType(ClassUtils.unwrap(actualType), dimension);
        }
        return clazz;
    }

    public static Set<Class<?>> getAllExtendedOrImplementedTypesAsSet(@Nullable Class<?> clazz) {
        Class<?> superclass;
        if (clazz == null) {
            return Collections.emptySet();
        }
        ArrayList classes = new ArrayList();
        do {
            classes.add(clazz);
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length <= 0) continue;
            classes.addAll(Arrays.asList(interfaces));
            for (Class<?> it : interfaces) {
                classes.addAll(ClassUtils.getAllExtendedOrImplementedTypesAsSet(it));
            }
        } while ((superclass = clazz.getSuperclass()) != null && (clazz = superclass) != Object.class);
        return new LinkedHashSet(classes);
    }

    public static Graph<Class<?>> getAllExtendedOrImplementedTypesAsGraph(@Nullable Class<?> clazz) {
        Class<?> superclass;
        if (clazz == null) {
            return new DirectedGraph();
        }
        DirectedGraph graph = new DirectedGraph();
        do {
            graph.addVertex(clazz);
            for (Class<?> it : clazz.getInterfaces()) {
                graph.addVertex(it);
                graph.addEdge(clazz, it);
                graph.addAll(ClassUtils.getAllExtendedOrImplementedTypesAsGraph(it));
            }
            superclass = clazz.getSuperclass();
            if (superclass == null) break;
            if (superclass == Object.class) continue;
            graph.addVertex(superclass);
            graph.addEdge(clazz, superclass);
        } while ((clazz = superclass) != Object.class);
        return graph;
    }

    public static List<Class<?>> resolveActualTypes(@Nullable Type type) {
        if (type instanceof Class) {
            return Collections.singletonList((Class)type);
        }
        if (type instanceof WildcardType) {
            Type t;
            WildcardType wildcardType = (WildcardType)type;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            Type type2 = t = ArrayUtils.exists(lowerBounds) ? lowerBounds[0] : wildcardType.getUpperBounds()[0];
            if (t instanceof Class) {
                return Collections.singletonList((Class)t);
            }
            if (t instanceof GenericArrayType) {
                return Collections.singletonList(Object[].class);
            }
            return Collections.emptyList();
        }
        if (type instanceof GenericArrayType) {
            return Collections.singletonList(Object[].class);
        }
        if (!(type instanceof ParameterizedType)) {
            return Collections.emptyList();
        }
        ArrayList types = new ArrayList();
        ParameterizedType paramType = (ParameterizedType)type;
        for (Type t : paramType.getActualTypeArguments()) {
            List<Class<?>> list = ClassUtils.resolveActualTypes(t);
            if (list.isEmpty()) continue;
            types.addAll(list);
        }
        return types;
    }
}

