/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import javax.annotation.Nullable;

public final class FilenameUtils {
    private static final char EXTENSION_SEPARATOR = '.';

    @ExcludeFromGeneratedJacocoReport
    private FilenameUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static int indexOfExtension(@Nullable String filename) {
        if (filename == null) {
            return -1;
        }
        int index = filename.lastIndexOf(46);
        return index == 0 ? -1 : index;
    }

    public static String getBaseName(@Nullable String filename) {
        if (filename == null) {
            return "";
        }
        int index = FilenameUtils.indexOfExtension(filename);
        return index == -1 ? filename : filename.substring(0, index);
    }

    public static String getExtension(@Nullable String filename) {
        if (filename == null) {
            return "";
        }
        int index = FilenameUtils.indexOfExtension(filename);
        return index == -1 ? "" : filename.substring(index + 1);
    }

    public static String replaceUnallowables(String filename) {
        return filename.replace('\\', '\uff3c').replace('/', '\uff0f').replace(':', '\uff1a').replace('*', '\uff0a').replace('?', '\uff1f').replace('\"', '\uff02').replace('<', '\uff1c').replace('>', '\uff1e').replace('|', '\uff5c').replaceAll("\\.{2,}+$", "\u2026").replaceAll("\\.$", "\uff0e");
    }
}

