/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ini4j.Config;
import org.ini4j.Ini;
import org.ini4j.Profile;

public final class IniUtils {
    @ExcludeFromGeneratedJacocoReport
    private IniUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    private static void configure(Ini ini) {
        Config conf = new Config();
        conf.setMultiSection(true);
        conf.setFileEncoding(StandardCharsets.UTF_8);
        ini.setConfig(conf);
    }

    public static Map<String, String> readSection(File file, String sectionName) {
        return (Map)IniUtils.read(file).get((Object)sectionName);
    }

    public static String readValue(File file, String sectionName, String name) {
        Profile.Section section = (Profile.Section)IniUtils.read(file).get((Object)sectionName);
        return (String)section.get((Object)name);
    }

    public static List<String> readValues(File file, String sectionName) {
        Profile.Section section = (Profile.Section)IniUtils.read(file).get((Object)sectionName);
        return new ArrayList<String>(section.values());
    }

    public static Ini read(File file) {
        try {
            Ini ini = new Ini(file);
            IniUtils.configure(ini);
            ini.load();
            return ini;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(File file, Map<String, Map<String, Object>> data) {
        Map<String, Set<Map.Entry<String, Object>>> entriesMap = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> ((Map)it.getValue()).entrySet()));
        IniUtils.writeEntries(file, entriesMap);
    }

    public static void writeEntries(File file, Map<String, Set<Map.Entry<String, Object>>> data) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            Ini ini = new Ini(file);
            IniUtils.configure(ini);
            data.forEach((sectionName, entries) -> {
                for (Map.Entry entry : entries) {
                    ini.put(sectionName, (String)entry.getKey(), entry.getValue());
                }
            });
            ini.store();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

