/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;

public final class NumberUtils {
    private static final NumberFormat formatter = NumberFormat.getInstance(Locale.US);

    @ExcludeFromGeneratedJacocoReport
    private NumberUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static Double toPositive(Double number) {
        return number == null || number <= 0.0 ? Double.valueOf(1.0) : number;
    }

    public static Float toPositive(Float number) {
        return number == null || number.floatValue() <= 0.0f ? Float.valueOf(1.0f) : number;
    }

    public static Long toPositive(Long number) {
        return number == null || number <= 0L ? Long.valueOf(1L) : number;
    }

    public static Integer toPositive(Integer number) {
        return number == null || number <= 0 ? Integer.valueOf(1) : number;
    }

    public static Short toPositive(Short number) {
        return number == null || number <= 0 ? Short.valueOf((short)1) : number;
    }

    public static Byte toPositive(Byte number) {
        return number == null || number <= 0 ? Byte.valueOf((byte)1) : number;
    }

    public static Double toNegative(Double number) {
        return number == null || number >= 0.0 ? Double.valueOf(-1.0) : number;
    }

    public static Float toNegative(Float number) {
        return number == null || number.floatValue() >= 0.0f ? Float.valueOf(-1.0f) : number;
    }

    public static Long toNegative(Long number) {
        return number == null || number >= 0L ? Long.valueOf(-1L) : number;
    }

    public static Integer toNegative(Integer number) {
        return number == null || number >= 0 ? Integer.valueOf(-1) : number;
    }

    public static Short toNegative(Short number) {
        return number == null || number >= 0 ? Short.valueOf((short)-1) : number;
    }

    public static Byte toNegative(Byte number) {
        return number == null || number >= 0 ? Byte.valueOf((byte)-1) : number;
    }

    public static Double ifNull(Double number, double defaultNumber) {
        return number == null ? defaultNumber : number;
    }

    public static Float ifNull(Float number, float defaultNumber) {
        return Float.valueOf(number == null ? defaultNumber : number.floatValue());
    }

    public static Long ifNull(Long number, long defaultNumber) {
        return number == null ? defaultNumber : number;
    }

    public static Integer ifNull(Integer number, int defaultNumber) {
        return number == null ? defaultNumber : number;
    }

    public static Short ifNull(Short number, short defaultNumber) {
        return number == null ? defaultNumber : number;
    }

    public static Byte ifNull(Byte number, byte defaultNumber) {
        return number == null ? defaultNumber : number;
    }

    public static String format(double decimal) {
        return formatter.format(decimal);
    }

    public static int getNumOfPlaces(long number) {
        if (number == Long.MIN_VALUE) {
            ++number;
        }
        return number == 0L ? 1 : (int)(Math.log10(Math.abs(number)) + 1.0);
    }

    public static int getNumOfPlaces(BigInteger bigInt) {
        return bigInt.abs().toString().length();
    }

    public static boolean hasDecimalPart(double number) {
        return number % 1.0 != 0.0;
    }

    public static boolean hasDecimalPart(BigDecimal bigDecimal) {
        return bigDecimal.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0;
    }

    public static long reverse(long number) {
        long reversed = 0L;
        while (number != 0L) {
            long digit = number % 10L;
            reversed = reversed * 10L + digit;
            number /= 10L;
        }
        return reversed;
    }

    public static BigInteger reverse(BigInteger bigInt) {
        BigInteger reversed = BigInteger.ZERO;
        while (!bigInt.equals(BigInteger.ZERO)) {
            BigInteger digit = bigInt.remainder(BigInteger.TEN);
            reversed = reversed.multiply(BigInteger.TEN).add(digit);
            bigInt = bigInt.divide(BigInteger.TEN);
        }
        return reversed;
    }

    static {
        formatter.setGroupingUsed(false);
    }
}

