/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.constant.DateType;
import io.github.imsejin.common.constant.OS;
import io.github.imsejin.common.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class PathnameUtils {
    private static final String WINDOWS_SEPARATOR = "\\\\";
    private static final String UNIX_SEPARATOR = "/";

    @ExcludeFromGeneratedJacocoReport
    private PathnameUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static String getCurrentPathname() {
        try {
            return Paths.get(".", new String[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String removeSeparators(String pathname) {
        return pathname.replaceAll(WINDOWS_SEPARATOR, "").replaceAll(UNIX_SEPARATOR, "");
    }

    public static String correct(boolean absolute, String pathname) {
        String trimmed = Arrays.stream(pathname.split(WINDOWS_SEPARATOR)).map(p -> String.join((CharSequence)"", p.split(UNIX_SEPARATOR))).filter(p -> !StringUtils.isNullOrBlank(p)).map(String::trim).collect(Collectors.joining(File.separator));
        return absolute && OS.getCurrentOS() != OS.WINDOWS ? UNIX_SEPARATOR + trimmed : trimmed;
    }

    public static String concat(boolean absolute, String ... pathnames) {
        return PathnameUtils.correct(absolute, String.join((CharSequence)File.separator, pathnames));
    }

    public static String appendYearMonth(String pathname) {
        LocalDateTime now = LocalDateTime.now();
        return PathnameUtils.concat(false, pathname, now.format(DateType.YEAR.getFormatter()), now.format(DateType.MONTH.getFormatter()));
    }

    public static String appendDate(String pathname) {
        LocalDateTime now = LocalDateTime.now();
        return PathnameUtils.concat(false, pathname, now.format(DateType.YEAR.getFormatter()), now.format(DateType.MONTH.getFormatter()), now.format(DateType.DAY.getFormatter()));
    }
}

