/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.assertion.Asserts;
import io.github.imsejin.common.assertion.lang.ObjectAssert;
import io.github.imsejin.common.assertion.lang.StringAssert;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class ReflectionUtils {
    @ExcludeFromGeneratedJacocoReport
    private ReflectionUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static List<Field> getInheritedFields(Class<?> type) {
        Asserts.that(type).isNotNull();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = type; clazz != null; clazz = clazz.getSuperclass()) {
            fields.addAll(0, Arrays.asList(clazz.getDeclaredFields()));
        }
        Predicate<Field> filter = it -> Modifier.isStatic(it.getModifiers());
        filter = filter.or(Field::isSynthetic);
        fields.removeIf(filter);
        return fields;
    }

    @Nullable
    public static Object getFieldValue(@Nullable Object instance, Field field) {
        boolean accessible;
        Asserts.that(field).isNotNull();
        if (!Modifier.isStatic(field.getModifiers())) {
            Asserts.that(instance).isNotNull();
        }
        if (!(accessible = field.isAccessible())) {
            field.setAccessible(true);
        }
        try {
            Object object = field.get(instance);
            return object;
        }
        catch (IllegalAccessException e) {
            String message = String.format("Failed to get value from the field(%s) of the class(%s)", field.getName(), field.getDeclaringClass().getName());
            throw new RuntimeException(message, e);
        }
        finally {
            if (!accessible) {
                field.setAccessible(false);
            }
        }
    }

    public static void setFieldValue(@Nullable Object instance, Field field, Object value) {
        boolean accessible;
        Asserts.that(field).isNotNull();
        if (!Modifier.isStatic(field.getModifiers())) {
            Asserts.that(instance).isNotNull();
        }
        if (field.getType().isPrimitive()) {
            ((ObjectAssert)Asserts.that(value).as("Value is not allowed to set null to primitive field: {0} <= null", field.getType())).isNotNull();
        }
        if (!(accessible = field.isAccessible())) {
            field.setAccessible(true);
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            String message = String.format("Failed to set value into the field(%s) of the class(%s)", field.getName(), field.getDeclaringClass().getName());
            throw new RuntimeException(message, e);
        }
        finally {
            if (!accessible) {
                field.setAccessible(false);
            }
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> type, Class<?> ... paramTypes) {
        Asserts.that(type).isNotNull();
        if (paramTypes != null) {
            Asserts.that(paramTypes).doesNotContainNull();
        }
        try {
            return type.getDeclaredConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            String message = String.format("Not found constructor: %s(%s)", type, Arrays.toString(paramTypes).replaceAll("[\\[\\]]", ""));
            throw new RuntimeException(message, e);
        }
    }

    public static <T> T instantiate(Class<T> type) {
        Constructor<T> constructor = ReflectionUtils.getDeclaredConstructor(type, new Class[0]);
        return ReflectionUtils.instantiate(constructor, new Object[0]);
    }

    public static <T> T instantiate(Constructor<T> constructor, Object ... initArgs) {
        boolean accessible;
        Asserts.that(constructor).isNotNull();
        if (initArgs != null) {
            Asserts.that(initArgs).isSameLength(constructor.getParameterTypes());
        }
        if (!(accessible = constructor.isAccessible())) {
            constructor.setAccessible(true);
        }
        try {
            T t = constructor.newInstance(initArgs);
            return t;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate by constructor: " + constructor, e);
        }
        finally {
            if (!accessible) {
                constructor.setAccessible(false);
            }
        }
    }

    public static Method getDeclaredMethod(Class<?> type, String name, Class<?> ... paramTypes) {
        Asserts.that(type).isNotNull();
        ((StringAssert)Asserts.that(name).isNotNull()).hasText();
        if (paramTypes != null) {
            Asserts.that(paramTypes).doesNotContainNull();
        }
        try {
            return type.getDeclaredMethod(name, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invoke(Method method, @Nullable Object instance, Object ... args) {
        boolean accessible;
        Asserts.that(method).isNotNull();
        if (!Modifier.isStatic(method.getModifiers())) {
            Asserts.that(instance).isNotNull();
        }
        if (args != null) {
            Asserts.that(args).isSameLength(method.getParameterTypes());
        }
        if (!(accessible = method.isAccessible())) {
            method.setAccessible(true);
        }
        try {
            Object object = method.invoke(instance, args);
            return object;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!accessible) {
                method.setAccessible(false);
            }
        }
    }

    public static Object execute(Executable executable, @Nullable Object instance, Object ... args) {
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return ReflectionUtils.invoke(method, instance, args);
        }
        if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            return ReflectionUtils.instantiate(constructor, args);
        }
        throw new UnsupportedOperationException("Unsupported implementation of Executable: " + executable);
    }
}

