/*
 * Decompiled with CFR 0.152.
 */
package io.github.imsejin.common.util;

import io.github.imsejin.common.annotation.ExcludeFromGeneratedJacocoReport;
import io.github.imsejin.common.util.CollectionUtils;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class StringUtils {
    private static final char WHITE_SPACE = ' ';
    private static final NumberFormat formatter = NumberFormat.getInstance(Locale.US);

    @ExcludeFromGeneratedJacocoReport
    private StringUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is not allowed to instantiate");
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String ifNullOrEmpty(String str, String defaultValue) {
        return StringUtils.isNullOrEmpty(str) ? defaultValue : str;
    }

    public static String ifNullOrEmpty(String str, Supplier<String> supplier) {
        return StringUtils.isNullOrEmpty(str) ? supplier.get() : str;
    }

    public static boolean isNullOrBlank(String str) {
        if (StringUtils.isNullOrEmpty(str)) {
            return true;
        }
        for (char c : str.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String ifNullOrBlank(String str, String defaultValue) {
        return StringUtils.isNullOrBlank(str) ? defaultValue : str;
    }

    public static String ifNullOrBlank(String str, Supplier<String> supplier) {
        return StringUtils.isNullOrBlank(str) ? supplier.get() : str;
    }

    public static boolean anyEquals(@Nullable String criterion, @Nullable Collection<String> strings) {
        if (CollectionUtils.isNullOrEmpty(strings)) {
            return false;
        }
        for (String string : strings) {
            if (!Objects.deepEquals(criterion, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyContains(@Nullable String criterion, @Nullable Iterable<String> strings) {
        if (criterion == null || strings == null || strings.spliterator().estimateSize() == 0L) {
            return false;
        }
        for (String string : strings) {
            if (string == null || !criterion.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isNullOrEmpty(str)) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String padStart(int len, String origin) {
        return StringUtils.padStart(len, origin, String.valueOf(' '));
    }

    public static String padStart(int len, String origin, String appendix) {
        int originLen = origin.length();
        if (originLen >= len) {
            return origin;
        }
        return StringUtils.repeat(appendix, len - originLen) + origin;
    }

    public static String padEnd(int len, String origin) {
        return StringUtils.padEnd(len, origin, String.valueOf(' '));
    }

    public static String padEnd(int len, String origin, String appendix) {
        int originLen = origin.length();
        if (originLen >= len) {
            return origin;
        }
        return origin + StringUtils.repeat(appendix, len - originLen);
    }

    public static int countOf(String origin, String keyword) {
        if (keyword.isEmpty()) {
            return origin.length();
        }
        int keywordLen = keyword.length();
        int count = 0;
        int i = origin.indexOf(keyword);
        while (i >= 0) {
            ++count;
            i = origin.indexOf(keyword, i + keywordLen);
        }
        return count;
    }

    public static String reverse(String str) {
        return new StringBuilder(str).reverse().toString();
    }

    public static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)(.*)" + regex, "$1" + replacement);
    }

    public static String formatComma(double amount) {
        return formatter.format(amount);
    }

    public static String formatComma(String amount) {
        return formatter.format(Double.parseDouble(amount));
    }

    public static String repeat(String str, int cnt) {
        return String.join((CharSequence)"", Collections.nCopies(cnt, str));
    }

    public static String repeat(char c, int cnt) {
        return String.join((CharSequence)"", Collections.nCopies(cnt, String.valueOf(c)));
    }

    @Nullable
    public static String find(String src, String regex, int group) {
        return StringUtils.find(src, Pattern.compile(regex), group);
    }

    @Nullable
    public static String find(String src, Pattern pattern, int group) {
        Matcher matcher = pattern.matcher(src);
        String result = null;
        while (matcher.find()) {
            result = matcher.group(group);
        }
        return result;
    }

    public static Map<Integer, String> find(String src, String regex, int flags, int ... groups) {
        return StringUtils.find(src, Pattern.compile(regex, flags), groups);
    }

    public static Map<Integer, String> find(String src, Pattern pattern, int ... groups) {
        Matcher matcher = pattern.matcher(src);
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        while (matcher.find()) {
            for (int group : groups) {
                result.put(group, matcher.group(group));
            }
        }
        return result;
    }

    public static String chop(String str) {
        return str.isEmpty() ? str : str.substring(0, str.length() - 1);
    }

    public static String getLastString(String str) {
        return str.isEmpty() ? str : String.valueOf(str.charAt(str.length() - 1));
    }

    public static int ordinalIndexOf(String str, char ch, int ordinal) {
        int index;
        if (ordinal == 0) {
            return -1;
        }
        if (ordinal > 0) {
            index = str.indexOf(ch);
            if (index == -1) {
                return -1;
            }
            for (int i = 1; i < ordinal && index != -1; ++i) {
                index = str.indexOf(ch, index + 1);
            }
        } else {
            index = str.lastIndexOf(ch);
            if (index == -1) {
                return -1;
            }
            for (int i = -1; i > ordinal && index != -1; --i) {
                index = str.lastIndexOf(ch, index - 1);
            }
        }
        return index;
    }

    public static int indexOfCurrentClosingBracket(@Nullable String str, int pos, char opener, char closer) {
        char c;
        int i;
        int depth;
        if (StringUtils.isNullOrEmpty(str)) {
            return -1;
        }
        char ch = str.charAt(pos);
        if (ch != opener) {
            depth = ch == closer ? 0 : 1;
            for (i = pos; i >= 0; --i) {
                c = str.charAt(i);
                if (c == closer) {
                    ++depth;
                }
                if (c != opener || --depth != 0) continue;
                pos = i;
                ch = str.charAt(pos);
                break;
            }
            if (ch != opener) {
                return -1;
            }
        }
        depth = 0;
        for (i = pos; i < str.length(); ++i) {
            c = str.charAt(i);
            if (c == opener) {
                ++depth;
            }
            if (c != closer || --depth != 0) continue;
            return i;
        }
        return -1;
    }
}

