/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.annotations;

import io.github.isagroup.PricingContext;
import io.github.isagroup.annotations.PricingPlanAware;
import io.github.isagroup.exceptions.PricingPlanEvaluationException;
import io.github.isagroup.models.Feature;
import io.github.isagroup.models.FeatureStatus;
import io.github.isagroup.models.PlanContextManager;
import io.github.isagroup.models.PricingManager;
import java.util.Map;
import java.util.Optional;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Aspect
@Component
public class PricingPlanAwareAspect {
    @Autowired
    private PricingContext pricingContext;

    @Around(value="@annotation(pricingPlanAware)")
    @Transactional(rollbackFor={PricingPlanEvaluationException.class})
    public Object validatePricingPlan(ProceedingJoinPoint joinPoint, PricingPlanAware pricingPlanAware) throws Throwable, PricingPlanEvaluationException {
        Object proceed = joinPoint.proceed();
        String featureId = pricingPlanAware.featureName();
        Boolean contextEvaluation = this.evaluateContext(featureId);
        if (contextEvaluation == null) {
            contextEvaluation = false;
        }
        if (!contextEvaluation.booleanValue()) {
            throw new PricingPlanEvaluationException("You have reached the limit of the feature: " + featureId);
        }
        return proceed;
    }

    private Boolean evaluateContext(String featureName) {
        PlanContextManager planContextManager = new PlanContextManager();
        try {
            planContextManager.setUserContext(this.pricingContext.getUserContext());
            planContextManager.setPlanContext(this.pricingContext.getPlanContext());
        }
        catch (NullPointerException e) {
            throw new PricingPlanEvaluationException("The pricing context is null. Please, chech the path to the configuration file.");
        }
        PricingManager pricingManager = this.pricingContext.getPricingManager();
        Map<String, Feature> features = pricingManager.getFeatures();
        Feature feature = features.get(featureName);
        if (feature == null) {
            throw new PricingPlanEvaluationException("The feature " + featureName + " does not exist in the current pricing configuration");
        }
        FeatureStatus featureStatus = new FeatureStatus();
        String expression = feature.getServerExpression() != null ? feature.getServerExpression() : feature.getExpression();
        Boolean eval = FeatureStatus.computeFeatureEvaluation(expression, planContextManager).orElseThrow(() -> new PricingPlanEvaluationException("Evaluation was null"));
        featureStatus.setEval(eval);
        Optional<String> userContextKey = FeatureStatus.computeUserContextVariable(expression);
        if (!userContextKey.isPresent()) {
            featureStatus.setUsed(null);
            featureStatus.setLimit(null);
        } else {
            featureStatus.setUsed(planContextManager.getUserContext().get(userContextKey.get()));
            featureStatus.setLimit(planContextManager.getPlanContext().get(featureName));
        }
        return featureStatus.getEval();
    }
}

