/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.models.Feature;
import io.github.isagroup.models.UsageLimit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AddOn {
    private String name;
    private String description;
    private List<String> availableFor;
    private List<String> dependsOn;
    private List<String> excludes;
    private Object price;
    private String unit;
    private Boolean isPrivate;
    private Map<String, Feature> features;
    private Map<String, UsageLimit> usageLimits;
    private Map<String, UsageLimit> usageLimitsExtensions;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getAvailableFor() {
        return this.availableFor;
    }

    public void setAvailableFor(List<String> availableFor) {
        this.availableFor = availableFor;
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public Object getPrice() {
        return this.price;
    }

    public void setPrice(Object price) {
        this.price = price;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    public void setIsPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public Map<String, Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Map<String, Feature> features) {
        this.features = features;
    }

    public Map<String, UsageLimit> getUsageLimits() {
        return this.usageLimits;
    }

    public void setUsageLimits(Map<String, UsageLimit> usageLimits) {
        this.usageLimits = usageLimits;
    }

    public Map<String, UsageLimit> getUsageLimitsExtensions() {
        return this.usageLimitsExtensions;
    }

    public void setUsageLimitsExtensions(Map<String, UsageLimit> usageLimitsExtensions) {
        this.usageLimitsExtensions = usageLimitsExtensions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.availableFor == null ? 0 : this.availableFor.hashCode());
        result = 31 * result + (this.dependsOn == null ? 0 : this.dependsOn.hashCode());
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.price == null ? 0 : this.price.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.isPrivate == null ? 0 : this.isPrivate.hashCode());
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.usageLimits == null ? 0 : this.usageLimits.hashCode());
        result = 31 * result + (this.usageLimitsExtensions == null ? 0 : this.usageLimitsExtensions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddOn other = (AddOn)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.availableFor == null ? other.availableFor != null : !this.availableFor.equals(other.availableFor)) {
            return false;
        }
        if (this.dependsOn == null ? other.dependsOn != null : !this.dependsOn.equals(other.dependsOn)) {
            return false;
        }
        if (this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes)) {
            return false;
        }
        if (this.price == null ? other.price != null : !this.price.equals(other.price)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        if (this.isPrivate == null ? other.isPrivate != null : !this.isPrivate.equals(other.isPrivate)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (this.usageLimits == null ? other.usageLimits != null : !this.usageLimits.equals(other.usageLimits)) {
            return false;
        }
        return !(this.usageLimitsExtensions == null ? other.usageLimitsExtensions != null : !this.usageLimitsExtensions.equals(other.usageLimitsExtensions));
    }

    public String toString() {
        return "AddOn [name=" + this.name + ", description=" + this.description + ", availableFor=" + String.valueOf(this.availableFor) + ", dependsOn=" + String.valueOf(this.dependsOn) + ", excludes=" + String.valueOf(this.excludes) + ", price=" + String.valueOf(this.price) + ", unit=" + this.unit + ", isPrivate=" + this.isPrivate + ", features=" + String.valueOf(this.features) + ", usageLimits=" + String.valueOf(this.usageLimits) + ", usageLimitsExtensions=" + String.valueOf(this.usageLimitsExtensions) + "]";
    }

    public Map<String, Object> serializeAddOn() {
        LinkedHashMap<String, Object> serializedAddOn = new LinkedHashMap<String, Object>();
        if (this.description != null) {
            serializedAddOn.put("description", this.description);
        }
        if (this.availableFor != null && !this.availableFor.isEmpty()) {
            serializedAddOn.put("availableFor", this.availableFor);
        }
        if (this.dependsOn != null && !this.dependsOn.isEmpty()) {
            serializedAddOn.put("dependsOn", this.dependsOn);
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            serializedAddOn.put("excludes", this.excludes);
        }
        if (this.isPrivate != null && this.isPrivate.booleanValue()) {
            serializedAddOn.put("private", this.isPrivate);
        }
        if (this.price != null) {
            serializedAddOn.put("price", this.price);
        }
        if (this.unit != null) {
            serializedAddOn.put("unit", this.unit);
        }
        Map features = this.serializeFeatures().orElse(null);
        Map usageLimits = this.serializeUsageLimits().orElse(null);
        Map usageLimitExtensions = this.serializeUsageLimitExtensions().orElse(null);
        serializedAddOn.put("features", features);
        serializedAddOn.put("usageLimits", usageLimits);
        serializedAddOn.put("usageLimitsExtensions", usageLimitExtensions);
        return serializedAddOn;
    }

    private <V> Optional<Map<String, V>> serializeValue(V value) {
        if (value == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, V> attributes = new LinkedHashMap<String, V>();
        attributes.put("value", value);
        return Optional.of(attributes);
    }

    private Optional<Map<String, Object>> serializeFeatures() {
        boolean featureMapIsEmpty;
        if (this.features == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedFeatures = new LinkedHashMap<String, Map<String, Object>>();
        for (Feature feature : this.features.values()) {
            Optional<Map<String, Object>> serializedFeature = this.serializeValue(feature.getValue());
            if (!serializedFeature.isPresent()) continue;
            serializedFeatures.put(feature.getName(), serializedFeature.get());
        }
        boolean bl = featureMapIsEmpty = serializedFeatures.size() == 0;
        if (featureMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedFeatures);
    }

    private Optional<Map<String, Object>> serializeUsageLimits() {
        boolean usageLimitMapIsEmpty;
        if (this.usageLimits == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedUsageLimits = new LinkedHashMap<String, Map<String, Object>>();
        for (UsageLimit usageLimit : this.usageLimits.values()) {
            Optional<Map<String, Object>> serializedUsageLimit = this.serializeValue(usageLimit.getValue());
            if (!serializedUsageLimit.isPresent()) continue;
            serializedUsageLimits.put(usageLimit.getName(), serializedUsageLimit.get());
        }
        boolean bl = usageLimitMapIsEmpty = serializedUsageLimits.size() == 0;
        if (usageLimitMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedUsageLimits);
    }

    private Optional<Map<String, Object>> serializeUsageLimitExtensions() {
        boolean usageLimitMapIsEmpty;
        if (this.usageLimitsExtensions == null) {
            return Optional.empty();
        }
        LinkedHashMap<String, Map<String, Object>> serializedUsageLimitExtensions = new LinkedHashMap<String, Map<String, Object>>();
        for (UsageLimit usageLimitExtension : this.usageLimitsExtensions.values()) {
            Optional<Map<String, Object>> serializedUsageLimit = this.serializeValue(usageLimitExtension.getValue());
            if (!serializedUsageLimit.isPresent()) continue;
            serializedUsageLimitExtensions.put(usageLimitExtension.getName(), serializedUsageLimit.get());
        }
        boolean bl = usageLimitMapIsEmpty = serializedUsageLimitExtensions.size() == 0;
        if (usageLimitMapIsEmpty) {
            return Optional.empty();
        }
        return Optional.of(serializedUsageLimitExtensions);
    }
}

