/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.exceptions.CloneFeatureException;
import io.github.isagroup.models.ValueType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Feature
implements Serializable {
    protected String name;
    protected String description;
    protected ValueType valueType;
    protected Object defaultValue;
    protected transient Object value;
    protected String expression;
    protected String serverExpression;
    protected String tag;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getServerExpression() {
        return this.serverExpression;
    }

    public void setServerExpression(String serverExpression) {
        this.serverExpression = serverExpression;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void prepareToPlanWriting() {
        this.name = null;
        this.value = null;
        this.description = null;
        this.defaultValue = null;
        this.expression = null;
        this.serverExpression = null;
        this.tag = null;
    }

    public boolean hasOverwrittenDefaultValue() {
        return !this.defaultValue.equals(this.value);
    }

    public String toString() {
        return "Feature [name=" + this.name + ", description=" + this.description + ", valueType=" + String.valueOf((Object)this.valueType) + ", defaultValue=" + String.valueOf(this.defaultValue) + ", expression=" + this.expression + ", serverExpression=" + this.serverExpression + ", tag=" + this.tag + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.serverExpression == null ? 0 : this.serverExpression.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Feature other = (Feature)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.valueType != other.valueType) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.serverExpression == null ? other.serverExpression != null : !this.serverExpression.equals(other.serverExpression)) {
            return false;
        }
        return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
    }

    public Map<String, Object> featureAttributesMap() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        if (this.description != null) {
            attributes.put("description", this.description);
        }
        if (this.valueType != null) {
            attributes.put("valueType", this.valueType.toString());
        }
        if (this.defaultValue != null) {
            attributes.put("defaultValue", this.defaultValue);
        }
        if (this.expression != null) {
            attributes.put("expression", this.expression);
        }
        if (this.serverExpression != null) {
            attributes.put("serverExpression", this.serverExpression);
        }
        if (this.tag != null) {
            attributes.put("tag", this.tag);
        }
        return attributes;
    }

    public abstract Map<String, Object> serializeFeature();

    public static Feature cloneFeature(Feature original) throws CloneFeatureException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(original);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (Feature)objectInputStream.readObject();
        }
        catch (Exception e) {
            throw new CloneFeatureException("Error cloning feature");
        }
    }
}

