/*
 * Decompiled with CFR 0.152.
 */
package io.github.isagroup.models;

import io.github.isagroup.models.PlanContextManager;
import java.util.Optional;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

public class FeatureStatus {
    private Boolean eval;
    private Object used;
    private Object limit;

    public Boolean getEval() {
        return this.eval;
    }

    public void setEval(Boolean eval) {
        this.eval = eval;
    }

    public Object getUsed() {
        return this.used;
    }

    public void setUsed(Object used) {
        this.used = used;
    }

    public Object getLimit() {
        return this.limit;
    }

    public void setLimit(Object limit) {
        this.limit = limit;
    }

    public static Optional<Boolean> computeFeatureEvaluation(String expression, PlanContextManager planContextManager) {
        SpelExpressionParser expressionParser = new SpelExpressionParser();
        SimpleEvaluationContext evaluationContext = SimpleEvaluationContext.forReadOnlyDataBinding().build();
        if (expression.trim().isEmpty()) {
            return Optional.of(false);
        }
        return Optional.ofNullable((Boolean)expressionParser.parseExpression(expression).getValue((EvaluationContext)evaluationContext, (Object)planContextManager, Boolean.class));
    }

    public static Optional<String> computeUserContextVariable(String expression) {
        if (!expression.contains("<") && !expression.contains(">")) {
            return Optional.ofNullable(null);
        }
        return Optional.ofNullable(expression.split("\\[[\\\"|']")[1].split("[\\\"|']\\]")[0].trim());
    }
}

